/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.manager.service;

import javax.annotation.Nonnull;
import org.hswebframework.ezorm.rdb.mapping.ReactiveRepository;
import org.jetlinks.community.network.NetworkConfigManager;
import org.jetlinks.community.network.NetworkProperties;
import org.jetlinks.community.network.NetworkType;
import org.jetlinks.community.network.manager.entity.NetworkConfigEntity;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class LocalNetworkConfigManager
implements NetworkConfigManager {
    private final ReactiveRepository<NetworkConfigEntity, String> reactiveRepository;

    public LocalNetworkConfigManager(ReactiveRepository<NetworkConfigEntity, String> reactiveRepository) {
        this.reactiveRepository = reactiveRepository;
    }

    public Flux<NetworkProperties> getAllConfigs() {
        return this.reactiveRepository.createQuery().fetch().flatMap(conf -> Mono.justOrEmpty((Object)conf.toNetworkProperties()));
    }

    public Mono<NetworkProperties> getConfig(NetworkType networkType, @Nonnull String id) {
        return this.reactiveRepository.findById((Object)id).flatMap(conf -> Mono.justOrEmpty((Object)conf.toNetworkProperties()));
    }
}

