/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.manager.debug;

import java.util.Arrays;
import java.util.Map;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.community.gateway.external.Message;
import org.jetlinks.community.gateway.external.SubscribeRequest;
import org.jetlinks.community.gateway.external.SubscriptionProvider;
import org.jetlinks.community.network.DefaultNetworkType;
import org.jetlinks.community.network.NetworkManager;
import org.jetlinks.community.network.NetworkType;
import org.jetlinks.community.network.manager.debug.DebugAuthenticationHandler;
import org.jetlinks.community.network.manager.web.request.MqttMessageRequest;
import org.jetlinks.community.network.manager.web.response.MqttMessageResponse;
import org.jetlinks.community.network.mqtt.client.MqttClient;
import org.jetlinks.core.utils.TopicUtils;
import org.jetlinks.rule.engine.executor.PayloadType;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;

@Component
public class MqttClientDebugSubscriptionProvider
implements SubscriptionProvider {
    private final NetworkManager networkManager;

    public MqttClientDebugSubscriptionProvider(NetworkManager networkManager) {
        this.networkManager = networkManager;
    }

    public String id() {
        return "network-client-mqtt-debug";
    }

    public String name() {
        return "MQTT\u5ba2\u6237\u7aef\u8c03\u8bd5";
    }

    public String[] getTopicPattern() {
        return new String[]{"/network/mqtt/client/*/_subscribe/*", "/network/mqtt/client/*/_publish/*"};
    }

    public Flux<Object> subscribe(SubscribeRequest request) {
        DebugAuthenticationHandler.handle(request);
        Map vars = TopicUtils.getPathVariables((String)"/network/mqtt/client/{id}/{pubsub}/{type}", (String)request.getTopic());
        String clientId = (String)vars.get("id");
        String pubsub = (String)vars.get("pubsub");
        PayloadType type = PayloadType.valueOf((String)((String)vars.get("type")).toUpperCase());
        return this.networkManager.getNetwork((NetworkType)DefaultNetworkType.MQTT_CLIENT, clientId).flatMapMany(mqtt -> "_subscribe".equals(pubsub) ? this.mqttClientSubscribe((MqttClient)mqtt, type, request) : this.mqttClientPublish((MqttClient)mqtt, type, request));
    }

    public Flux<Object> mqttClientSubscribe(MqttClient client, PayloadType type, SubscribeRequest request) {
        String topics = request.getString("topics", "/#");
        return client.subscribe(Arrays.asList(topics.split("[\n]"))).map(mqttMessage -> Message.success((String)request.getId(), (String)request.getTopic(), (Object)MqttMessageResponse.of(mqttMessage, type)));
    }

    public Flux<String> mqttClientPublish(MqttClient client, PayloadType type, SubscribeRequest request) {
        MqttMessageRequest messageRequest = (MqttMessageRequest)FastBeanCopier.copy((Object)request.values(), (Object)new MqttMessageRequest(), (String[])new String[0]);
        return client.publish(MqttMessageRequest.of(messageRequest, type)).thenReturn((Object)"\u63a8\u9001\u6210\u529f").flux();
    }
}

