/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.tcp.server;

import io.vertx.core.net.SocketAddress;
import java.util.HashMap;
import java.util.Map;
import org.jetlinks.community.ValueObject;
import org.jetlinks.community.network.AbstractServerNetworkConfig;
import org.jetlinks.community.network.resource.NetworkTransport;
import org.jetlinks.community.network.tcp.parser.PayloadParserType;
import org.jetlinks.rule.engine.executor.PayloadType;

public class TcpServerProperties
extends AbstractServerNetworkConfig
implements ValueObject {
    private PayloadType payloadType;
    private PayloadParserType parserType;
    private Map<String, Object> parserConfiguration = new HashMap<String, Object>();
    private boolean tcpKeepAlive = false;
    private int instance = Runtime.getRuntime().availableProcessors();

    public SocketAddress createSocketAddress() {
        return SocketAddress.inetSocketAddress((int)this.port, (String)this.host);
    }

    public Map<String, Object> values() {
        return this.parserConfiguration;
    }

    public NetworkTransport getTransport() {
        return NetworkTransport.TCP;
    }

    public String getSchema() {
        return "tcp";
    }

    public static TcpServerPropertiesBuilder builder() {
        return new TcpServerPropertiesBuilder();
    }

    public PayloadType getPayloadType() {
        return this.payloadType;
    }

    public PayloadParserType getParserType() {
        return this.parserType;
    }

    public Map<String, Object> getParserConfiguration() {
        return this.parserConfiguration;
    }

    public boolean isTcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    public int getInstance() {
        return this.instance;
    }

    public void setPayloadType(PayloadType payloadType) {
        this.payloadType = payloadType;
    }

    public void setParserType(PayloadParserType parserType) {
        this.parserType = parserType;
    }

    public void setParserConfiguration(Map<String, Object> parserConfiguration) {
        this.parserConfiguration = parserConfiguration;
    }

    public void setTcpKeepAlive(boolean tcpKeepAlive) {
        this.tcpKeepAlive = tcpKeepAlive;
    }

    public void setInstance(int instance) {
        this.instance = instance;
    }

    public TcpServerProperties() {
    }

    public TcpServerProperties(PayloadType payloadType, PayloadParserType parserType, Map<String, Object> parserConfiguration, boolean tcpKeepAlive, int instance) {
        this.payloadType = payloadType;
        this.parserType = parserType;
        this.parserConfiguration = parserConfiguration;
        this.tcpKeepAlive = tcpKeepAlive;
        this.instance = instance;
    }

    public static class TcpServerPropertiesBuilder {
        private PayloadType payloadType;
        private PayloadParserType parserType;
        private Map<String, Object> parserConfiguration;
        private boolean tcpKeepAlive;
        private int instance;

        TcpServerPropertiesBuilder() {
        }

        public TcpServerPropertiesBuilder payloadType(PayloadType payloadType) {
            this.payloadType = payloadType;
            return this;
        }

        public TcpServerPropertiesBuilder parserType(PayloadParserType parserType) {
            this.parserType = parserType;
            return this;
        }

        public TcpServerPropertiesBuilder parserConfiguration(Map<String, Object> parserConfiguration) {
            this.parserConfiguration = parserConfiguration;
            return this;
        }

        public TcpServerPropertiesBuilder tcpKeepAlive(boolean tcpKeepAlive) {
            this.tcpKeepAlive = tcpKeepAlive;
            return this;
        }

        public TcpServerPropertiesBuilder instance(int instance) {
            this.instance = instance;
            return this;
        }

        public TcpServerProperties build() {
            return new TcpServerProperties(this.payloadType, this.parserType, this.parserConfiguration, this.tcpKeepAlive, this.instance);
        }

        public String toString() {
            return "TcpServerProperties.TcpServerPropertiesBuilder(payloadType=" + this.payloadType + ", parserType=" + (Object)((Object)this.parserType) + ", parserConfiguration=" + this.parserConfiguration + ", tcpKeepAlive=" + this.tcpKeepAlive + ", instance=" + this.instance + ")";
        }
    }
}

