/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.tcp.gateway.device;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Optional;
import org.jetlinks.community.gateway.monitor.DeviceGatewayMonitor;
import org.jetlinks.community.network.tcp.TcpMessage;
import org.jetlinks.community.network.tcp.client.TcpClient;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.core.server.session.DeviceSession;
import reactor.core.publisher.Mono;

class UnknownTcpDeviceSession
implements DeviceSession {
    private final String id;
    private final TcpClient client;
    private final Transport transport;
    private long lastPingTime = System.currentTimeMillis();
    private final long connectTime = System.currentTimeMillis();
    private final DeviceGatewayMonitor monitor;
    private Duration keepAliveTimeout;

    UnknownTcpDeviceSession(String id, TcpClient client, Transport transport, DeviceGatewayMonitor monitor) {
        this.id = id;
        this.client = client;
        this.transport = transport;
        this.monitor = monitor;
    }

    public String getDeviceId() {
        return "unknown";
    }

    public DeviceOperator getOperator() {
        return null;
    }

    public long lastPingTime() {
        return this.lastPingTime;
    }

    public long connectTime() {
        return this.connectTime;
    }

    public Mono<Boolean> send(EncodedMessage encodedMessage) {
        return this.client.send(new TcpMessage(encodedMessage.getPayload())).doOnSuccess(ignore -> this.monitor.sentMessage());
    }

    public void close() {
        this.client.shutdown();
    }

    public void ping() {
        this.lastPingTime = System.currentTimeMillis();
        this.client.keepAlive();
    }

    public boolean isAlive() {
        return this.client.isAlive();
    }

    public void onClose(Runnable call) {
        this.client.onDisconnect(call);
    }

    public void setKeepAliveTimeout(Duration keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public Optional<InetSocketAddress> getClientAddress() {
        return Optional.of(this.client.getRemoteAddress());
    }

    public String getId() {
        return this.id;
    }

    public Transport getTransport() {
        return this.transport;
    }
}

