/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.http.device;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetlinks.community.network.http.server.HttpExchange;
import org.jetlinks.core.message.codec.http.Header;
import org.jetlinks.core.message.codec.http.HttpExchangeMessage;
import org.jetlinks.core.message.codec.http.HttpResponseMessage;
import org.jetlinks.core.message.codec.http.MultiPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import reactor.core.publisher.Mono;

public class HttpServerExchangeMessage
implements HttpExchangeMessage {
    private static final Logger log = LoggerFactory.getLogger(HttpServerExchangeMessage.class);
    AtomicReference<Boolean> responded = new AtomicReference<Boolean>(false);
    MultiPart multiPart;
    private final HttpExchange exchange;
    private final ByteBuf payload;

    public HttpServerExchangeMessage(HttpExchange exchange, ByteBuf payload, MultiPart multiPart) {
        this.exchange = exchange;
        this.payload = payload;
        this.multiPart = multiPart;
    }

    @Nonnull
    public Mono<Void> response(@Nonnull HttpResponseMessage message) {
        return Mono.defer(() -> {
            if (!this.responded.getAndSet(true).booleanValue() && !this.exchange.isClosed()) {
                if (log.isDebugEnabled()) {
                    log.debug("\u54cd\u5e94HTTP\u8bf7\u6c42:\n{}", (Object)message.print());
                }
                return this.exchange.response(message);
            }
            return Mono.empty();
        });
    }

    public Optional<MultiPart> multiPart() {
        return Optional.ofNullable(this.multiPart).filter(part -> part.getParts().size() > 0);
    }

    @Nonnull
    public String getUrl() {
        return this.exchange.request().getUrl();
    }

    @Nonnull
    public HttpMethod getMethod() {
        return this.exchange.request().getMethod();
    }

    @Nullable
    public MediaType getContentType() {
        return this.exchange.request().getContentType();
    }

    @Nonnull
    public List<Header> getHeaders() {
        return this.exchange.request().getHeaders();
    }

    @Nullable
    public Map<String, String> getQueryParameters() {
        return this.exchange.request().getQueryParameters();
    }

    @Nonnull
    public ByteBuf getPayload() {
        return this.payload;
    }

    public String toString() {
        return this.print();
    }
}

