/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.mqtt.server.vertx;

import io.vertx.core.Vertx;
import io.vertx.mqtt.MqttServer;
import io.vertx.mqtt.MqttServerOptions;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.i18n.LocaleUtils;
import org.jetlinks.community.network.DefaultNetworkType;
import org.jetlinks.community.network.Network;
import org.jetlinks.community.network.NetworkProperties;
import org.jetlinks.community.network.NetworkProvider;
import org.jetlinks.community.network.NetworkType;
import org.jetlinks.community.network.mqtt.server.vertx.VertxMqttServer;
import org.jetlinks.community.network.mqtt.server.vertx.VertxMqttServerProperties;
import org.jetlinks.community.network.security.CertificateManager;
import org.jetlinks.community.network.security.VertxKeyCertTrustOptions;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.DefaultConfigMetadata;
import org.jetlinks.core.metadata.types.BooleanType;
import org.jetlinks.core.metadata.types.IntType;
import org.jetlinks.core.metadata.types.StringType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
public class DefaultVertxMqttServerProvider
implements NetworkProvider<VertxMqttServerProperties> {
    private static final Logger log = LoggerFactory.getLogger(DefaultVertxMqttServerProvider.class);
    private final CertificateManager certificateManager;
    private final Vertx vertx;

    public DefaultVertxMqttServerProvider(CertificateManager certificateManager, Vertx vertx) {
        this.certificateManager = certificateManager;
        this.vertx = vertx;
    }

    @Nonnull
    public NetworkType getType() {
        return DefaultNetworkType.MQTT_SERVER;
    }

    @Nonnull
    public Mono<Network> createNetwork(@Nonnull VertxMqttServerProperties properties) {
        VertxMqttServer server = new VertxMqttServer(properties.getId());
        return this.initServer(server, properties);
    }

    private Mono<Network> initServer(VertxMqttServer server, VertxMqttServerProperties properties) {
        int numberOfInstance = Math.max(1, properties.getInstance());
        return this.convert(properties).map(options -> {
            ArrayList<MqttServer> instances = new ArrayList<MqttServer>(numberOfInstance);
            for (int i = 0; i < numberOfInstance; ++i) {
                MqttServer mqttServer = MqttServer.create((Vertx)this.vertx, (MqttServerOptions)options);
                instances.add(mqttServer);
            }
            server.setBind(new InetSocketAddress(options.getHost(), options.getPort()));
            server.setMqttServer(instances);
            for (MqttServer instance : instances) {
                this.vertx.nettyEventLoopGroup().execute(() -> instance.listen(result -> {
                    if (result.succeeded()) {
                        log.debug("startup mqtt server [{}] on port :{} ", (Object)properties.getId(), (Object)((MqttServer)result.result()).actualPort());
                    } else {
                        server.setLastError(result.cause().getMessage());
                        log.warn("startup mqtt server [{}] error ", (Object)properties.getId(), (Object)result.cause());
                    }
                }));
            }
            return server;
        });
    }

    public Mono<Network> reload(@Nonnull Network network, @Nonnull VertxMqttServerProperties properties) {
        log.debug("reload mqtt server[{}]", (Object)properties.getId());
        return this.initServer((VertxMqttServer)network, properties);
    }

    @Nullable
    public ConfigMetadata getConfigMetadata() {
        return new DefaultConfigMetadata().add("id", "id", "", (DataType)new StringType()).add("host", "\u672c\u5730\u5730\u5740", "", (DataType)new StringType()).add("port", "\u672c\u5730\u7aef\u53e3", "", (DataType)new IntType()).add("publicHost", "\u516c\u7f51\u5730\u5740", "", (DataType)new StringType()).add("publicPort", "\u516c\u7f51\u7aef\u53e3", "", (DataType)new IntType()).add("certId", "\u8bc1\u4e66id", "", (DataType)new StringType()).add("secure", "\u5f00\u542fTSL", "", (DataType)new BooleanType()).add("secure", "\u5f00\u542fTSL", "", (DataType)new BooleanType()).add("maxMessageSize", "\u6700\u5927\u6d88\u606f\u957f\u5ea6", "", (DataType)new StringType());
    }

    @Nonnull
    public Mono<VertxMqttServerProperties> createConfig(@Nonnull NetworkProperties properties) {
        return (Mono)Mono.defer(() -> {
            VertxMqttServerProperties config = (VertxMqttServerProperties)((Object)((Object)FastBeanCopier.copy((Object)properties.getConfigurations(), (Object)((Object)new VertxMqttServerProperties()), (String[])new String[0])));
            config.setId(properties.getId());
            config.validate();
            return Mono.just((Object)((Object)config));
        }).as(LocaleUtils::transform);
    }

    private Mono<MqttServerOptions> convert(VertxMqttServerProperties properties) {
        MqttServerOptions options = new MqttServerOptions();
        options.setPort(properties.getPort());
        options.setHost(properties.getHost());
        options.setMaxMessageSize(properties.getMaxMessageSize());
        options.setTcpKeepAlive(true);
        if (properties.isSecure()) {
            options.setSsl(true);
            return this.certificateManager.getCertificate(properties.getCertId()).map(VertxKeyCertTrustOptions::new).doOnNext(arg_0 -> ((MqttServerOptions)options).setKeyCertOptions(arg_0)).doOnNext(arg_0 -> ((MqttServerOptions)options).setTrustOptions(arg_0)).thenReturn((Object)options);
        }
        return Mono.just((Object)options);
    }

    public boolean isReusable() {
        return true;
    }
}

