/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.mqtt.server;

import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Optional;
import java.util.function.Consumer;
import org.jetlinks.community.network.mqtt.server.MqttPublishing;
import org.jetlinks.community.network.mqtt.server.MqttSubscription;
import org.jetlinks.community.network.mqtt.server.MqttUnSubscription;
import org.jetlinks.core.message.codec.MqttMessage;
import org.jetlinks.core.server.ClientConnection;
import org.jetlinks.core.server.mqtt.MqttAuth;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface MqttConnection
extends ClientConnection {
    public String getClientId();

    public Optional<MqttAuth> getAuth();

    public void reject(MqttConnectReturnCode var1);

    public MqttConnection accept();

    public Optional<MqttMessage> getWillMessage();

    public Flux<MqttPublishing> handleMessage();

    public Mono<Void> publish(MqttMessage var1);

    public Flux<MqttSubscription> handleSubscribe(boolean var1);

    public Flux<MqttUnSubscription> handleUnSubscribe(boolean var1);

    public void onClose(Consumer<MqttConnection> var1);

    public boolean isAlive();

    public Mono<Void> close();

    public long getLastPingTime();

    public void keepAlive();

    public Duration getKeepAliveTimeout();

    public void setKeepAliveTimeout(Duration var1);

    public InetSocketAddress getClientAddress();
}

