/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.mqtt.server.vertx;

import org.jetlinks.community.network.AbstractServerNetworkConfig;
import org.jetlinks.community.network.resource.NetworkTransport;

public class VertxMqttServerProperties
extends AbstractServerNetworkConfig {
    private int instance = Runtime.getRuntime().availableProcessors();
    private int maxMessageSize = 8096;

    public NetworkTransport getTransport() {
        return NetworkTransport.TCP;
    }

    public String getSchema() {
        return "mqtt";
    }

    public static VertxMqttServerPropertiesBuilder builder() {
        return new VertxMqttServerPropertiesBuilder();
    }

    public int getInstance() {
        return this.instance;
    }

    public int getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public void setInstance(int instance) {
        this.instance = instance;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this.maxMessageSize = maxMessageSize;
    }

    public VertxMqttServerProperties() {
    }

    public VertxMqttServerProperties(int instance, int maxMessageSize) {
        this.instance = instance;
        this.maxMessageSize = maxMessageSize;
    }

    public static class VertxMqttServerPropertiesBuilder {
        private int instance;
        private int maxMessageSize;

        VertxMqttServerPropertiesBuilder() {
        }

        public VertxMqttServerPropertiesBuilder instance(int instance) {
            this.instance = instance;
            return this;
        }

        public VertxMqttServerPropertiesBuilder maxMessageSize(int maxMessageSize) {
            this.maxMessageSize = maxMessageSize;
            return this;
        }

        public VertxMqttServerProperties build() {
            return new VertxMqttServerProperties(this.instance, this.maxMessageSize);
        }

        public String toString() {
            return "VertxMqttServerProperties.VertxMqttServerPropertiesBuilder(instance=" + this.instance + ", maxMessageSize=" + this.maxMessageSize + ")";
        }
    }
}

