/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.mqtt.gateway.device.session;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.jetlinks.community.gateway.monitor.DeviceGatewayMonitor;
import org.jetlinks.community.network.mqtt.server.MqttConnection;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.message.codec.MqttMessage;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.core.server.session.DeviceSession;
import org.jetlinks.core.server.session.ReplaceableDeviceSession;
import reactor.core.publisher.Mono;

public class MqttConnectionSession
implements DeviceSession,
ReplaceableDeviceSession {
    @Generated
    private final String id;
    @Generated
    private final DeviceOperator operator;
    @Generated
    private final Transport transport;
    @Generated
    private MqttConnection connection;
    private final DeviceGatewayMonitor monitor;
    private final long connectTime = System.currentTimeMillis();

    public MqttConnectionSession(String id, DeviceOperator operator, Transport transport, MqttConnection connection, DeviceGatewayMonitor monitor) {
        this.id = id;
        this.operator = operator;
        this.transport = transport;
        this.connection = connection;
        this.monitor = monitor;
    }

    public String getDeviceId() {
        return this.id;
    }

    public long lastPingTime() {
        return this.connection.getLastPingTime();
    }

    public long connectTime() {
        return this.connectTime;
    }

    public Mono<Boolean> send(EncodedMessage encodedMessage) {
        return Mono.defer(() -> this.connection.publish((MqttMessage)encodedMessage)).doOnSuccess(nil -> this.monitor.sentMessage()).thenReturn((Object)true);
    }

    public void close() {
        this.connection.close().subscribe();
    }

    public void ping() {
        this.connection.keepAlive();
    }

    public void setKeepAliveTimeout(Duration timeout) {
        this.connection.setKeepAliveTimeout(timeout);
    }

    public boolean isAlive() {
        return this.connection.isAlive();
    }

    public void onClose(Runnable call) {
        this.connection.onClose((MqttConnection c) -> call.run());
    }

    public Optional<InetSocketAddress> getClientAddress() {
        return Optional.ofNullable(this.connection.getClientAddress());
    }

    public void replaceWith(DeviceSession session) {
        if (session instanceof MqttConnectionSession) {
            MqttConnectionSession connectionSession = (MqttConnectionSession)session;
            if (!this.connection.equals(connectionSession.connection)) {
                this.connection.close().subscribe();
            }
            this.connection = connectionSession.connection;
        }
    }

    public boolean isChanged(DeviceSession another) {
        if (another.isWrapFrom(MqttConnectionSession.class)) {
            return !this.connection.equals(((MqttConnectionSession)another.unwrap(MqttConnectionSession.class)).getConnection());
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MqttConnectionSession that = (MqttConnectionSession)o;
        return Objects.equals(this.connection, that.connection);
    }

    public int hashCode() {
        return Objects.hash(this.connection);
    }

    public String getId() {
        return this.id;
    }

    public DeviceOperator getOperator() {
        return this.operator;
    }

    public Transport getTransport() {
        return this.transport;
    }

    public MqttConnection getConnection() {
        return this.connection;
    }
}

