/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.logging.event.handler;

import org.jetlinks.community.elastic.search.index.DefaultElasticSearchIndexMetadata;
import org.jetlinks.community.elastic.search.index.ElasticIndex;
import org.jetlinks.community.elastic.search.index.ElasticSearchIndexManager;
import org.jetlinks.community.elastic.search.index.ElasticSearchIndexMetadata;
import org.jetlinks.community.elastic.search.service.ElasticSearchService;
import org.jetlinks.community.logging.access.SerializableAccessLog;
import org.jetlinks.community.logging.event.handler.LoggerIndexProvider;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.types.DateTimeType;
import org.jetlinks.core.metadata.types.ObjectType;
import org.jetlinks.core.metadata.types.StringType;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
@Order(value=5)
public class AccessLoggerEventHandler {
    private static final Logger log = LoggerFactory.getLogger(AccessLoggerEventHandler.class);
    private final ElasticSearchService elasticSearchService;

    public AccessLoggerEventHandler(ElasticSearchService elasticSearchService, ElasticSearchIndexManager indexManager) {
        this.elasticSearchService = elasticSearchService;
        indexManager.putIndex((ElasticSearchIndexMetadata)new DefaultElasticSearchIndexMetadata(LoggerIndexProvider.ACCESS.getIndex()).addProperty("requestTime", (DataType)new DateTimeType()).addProperty("responseTime", (DataType)new DateTimeType()).addProperty("action", (DataType)new StringType()).addProperty("ip", (DataType)new StringType()).addProperty("url", (DataType)new StringType()).addProperty("httpHeaders", (DataType)new ObjectType()).addProperty("context", (DataType)new ObjectType().addProperty("userId", (DataType)new StringType()).addProperty("username", (DataType)new StringType()))).subscribe();
    }

    @EventListener
    public void acceptAccessLoggerInfo(SerializableAccessLog info) {
        this.elasticSearchService.commit((ElasticIndex)LoggerIndexProvider.ACCESS, (Publisher)Mono.just((Object)info)).subscribe();
    }
}

