/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.alarm;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.jetlinks.community.rule.engine.alarm.AlarmTarget;
import org.jetlinks.community.rule.engine.alarm.AlarmTargetSupplier;
import org.jetlinks.community.rule.engine.alarm.DeviceAlarmTarget;
import org.jetlinks.community.rule.engine.alarm.OtherAlarmTarget;
import org.jetlinks.community.rule.engine.alarm.ProductAlarmTarget;

public class CustomAlarmTargetSupplier
implements AlarmTargetSupplier {
    static Map<String, AlarmTarget> targets = new LinkedHashMap<String, AlarmTarget>();
    public static CustomAlarmTargetSupplier defaultSupplier = new CustomAlarmTargetSupplier();

    public static void register(AlarmTarget target) {
        targets.put(target.getType(), target);
    }

    @Override
    public Optional<AlarmTarget> getByType(String type) {
        return Optional.ofNullable(targets.get(type));
    }

    @Override
    public Map<String, AlarmTarget> getAll() {
        return targets;
    }

    static {
        CustomAlarmTargetSupplier.register(new ProductAlarmTarget());
        CustomAlarmTargetSupplier.register(new DeviceAlarmTarget());
        CustomAlarmTargetSupplier.register(new OtherAlarmTarget());
    }
}

