/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.manager.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.web.api.crud.entity.PagerResult;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.authorization.annotation.Resource;
import org.jetlinks.community.notify.manager.service.NotifyHistory;
import org.jetlinks.community.notify.manager.service.NotifyHistoryRepository;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/notify/history"})
@Resource(id="notifier", name="\u901a\u77e5\u7ba1\u7406")
@Tag(name="\u6d88\u606f\u901a\u77e5\u8bb0\u5f55")
public class NotifierHistoryController {
    private final NotifyHistoryRepository repository;

    public NotifierHistoryController(NotifyHistoryRepository repository) {
        this.repository = repository;
    }

    @PostMapping(value={"/config/{configId}/_query"})
    @Operation(summary="\u6839\u636e\u901a\u77e5\u914d\u7f6eID\u67e5\u8be2\u901a\u77e5\u8bb0\u5f55")
    public Mono<PagerResult<NotifyHistory>> queryPagerByConfigId(@PathVariable String configId, @RequestBody Mono<QueryParamEntity> queryParam) {
        return queryParam.flatMap(param -> (Mono)param.toNestQuery(q -> {
            Query cfr_ignored_0 = (Query)q.is(NotifyHistory::getNotifierId, (Object)configId);
        }).execute(this.repository::queryPager));
    }

    @PostMapping(value={"/template/{templateId}/_query"})
    @Operation(summary="\u6839\u636e\u901a\u77e5\u6a21\u7248ID\u67e5\u8be2\u901a\u77e5\u8bb0\u5f55")
    public Mono<PagerResult<NotifyHistory>> queryPagerByTemplateId(@PathVariable String templateId, @RequestBody Mono<QueryParamEntity> queryParam) {
        return queryParam.flatMap(param -> (Mono)param.toNestQuery(q -> {
            Query cfr_ignored_0 = (Query)q.is(NotifyHistory::getTemplateId, (Object)templateId);
        }).execute(this.repository::queryPager));
    }
}

