/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.manager.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.validation.constraints.NotNull;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.authorization.annotation.ResourceAction;
import org.hswebframework.web.exception.NotFoundException;
import org.jetlinks.community.notify.NotifierManager;
import org.jetlinks.community.notify.NotifyType;
import org.jetlinks.community.notify.manager.entity.NotifyTemplateEntity;
import org.jetlinks.community.notify.manager.service.NotifyConfigService;
import org.jetlinks.community.notify.template.TemplateManager;
import org.jetlinks.core.Values;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/notifier"})
@Resource(id="notifier", name="\u901a\u77e5\u7ba1\u7406")
@Tag(name="\u6d88\u606f\u901a\u77e5\u7ba1\u7406")
public class NotifierController {
    private final NotifyConfigService configService;
    private final NotifierManager notifierManager;
    private final TemplateManager templateManager;

    @PostMapping(value={"/{notifierId}/_send"})
    @ResourceAction(id="send", name="\u53d1\u9001\u901a\u77e5")
    @Operation(summary="\u53d1\u9001\u6d88\u606f\u901a\u77e5")
    public Mono<Void> sendNotify(@PathVariable @Parameter(description="\u901a\u77e5\u914d\u7f6eID") String notifierId, @RequestBody Mono<SendNotifyRequest> mono) {
        return mono.flatMap(tem -> {
            NotifyType type = NotifyType.of((String)tem.getTemplate().getType());
            return Mono.zip((Mono)this.notifierManager.getNotifier(type, notifierId).switchIfEmpty(Mono.error(() -> new NotFoundException("error.notifier_does_not_exist", new Object[]{notifierId}))), (Mono)this.templateManager.createTemplate(type, tem.getTemplate().toTemplateProperties()), (notifier, template) -> notifier.send(template, Values.of(tem.getContext()))).flatMap(Function.identity());
        });
    }

    @PostMapping(value={"/{notifierId}/{templateId}/_send"})
    @ResourceAction(id="send", name="\u53d1\u9001\u901a\u77e5")
    @Operation(summary="\u6839\u636e\u914d\u7f6e\u548c\u6a21\u7248ID\u53d1\u9001\u6d88\u606f\u901a\u77e5")
    public Mono<Void> sendNotify(@PathVariable @Parameter(description="\u901a\u77e5\u914d\u7f6eID") String notifierId, @PathVariable @Parameter(description="\u901a\u77e5\u6a21\u7248ID") String templateId, @RequestBody Mono<Map<String, Object>> contextMono) {
        return this.configService.findById(notifierId).flatMap(conf -> Mono.zip((Mono)this.notifierManager.getNotifier(NotifyType.of((String)conf.getType()), notifierId).switchIfEmpty(Mono.error(() -> new NotFoundException("error.notifier_does_not_exist", new Object[]{notifierId}))), (Mono)contextMono, (notifier, contextMap) -> notifier.send(templateId, Values.of((Map)contextMap))).flatMap(Function.identity()));
    }

    public NotifierController(NotifyConfigService configService, NotifierManager notifierManager, TemplateManager templateManager) {
        this.configService = configService;
        this.notifierManager = notifierManager;
        this.templateManager = templateManager;
    }

    public static class SendNotifyRequest {
        @NotNull
        @Schema(description="\u901a\u77e5\u6a21\u7248")
        private NotifyTemplateEntity template;
        @Schema(description="\u4e0a\u4e0b\u6587\u6570\u636e")
        private Map<String, Object> context = new HashMap<String, Object>();

        @NotNull
        public NotifyTemplateEntity getTemplate() {
            return this.template;
        }

        public Map<String, Object> getContext() {
            return this.context;
        }

        public void setTemplate(@NotNull NotifyTemplateEntity template) {
            this.template = template;
        }

        public void setContext(Map<String, Object> context) {
            this.context = context;
        }
    }
}

