/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.manager.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.hswebframework.web.authorization.annotation.QueryAction;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.crud.web.reactive.ReactiveServiceCrudController;
import org.jetlinks.community.notify.NotifierProvider;
import org.jetlinks.community.notify.NotifyType;
import org.jetlinks.community.notify.manager.entity.NotifyConfigEntity;
import org.jetlinks.community.notify.manager.service.NotifyConfigService;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/notifier/config"})
@Resource(id="notifier", name="\u901a\u77e5\u7ba1\u7406")
@Tag(name="\u6d88\u606f\u901a\u77e5\u914d\u7f6e")
public class NotifierConfigController
implements ReactiveServiceCrudController<NotifyConfigEntity, String> {
    private final NotifyConfigService notifyConfigService;
    private final List<NotifierProvider> providers;

    public NotifierConfigController(NotifyConfigService notifyConfigService, List<NotifierProvider> providers) {
        this.notifyConfigService = notifyConfigService;
        this.providers = providers;
    }

    public NotifyConfigService getService() {
        return this.notifyConfigService;
    }

    @GetMapping(value={"/{type}/{provider}/metadata"})
    @QueryAction
    @Operation(summary="\u83b7\u53d6\u6307\u5b9a\u7c7b\u578b\u548c\u670d\u52a1\u5546\u6240\u9700\u914d\u7f6e\u5b9a\u4e49")
    public Mono<ConfigMetadata> getAllTypes(@PathVariable @Parameter(description="\u901a\u77e5\u7c7b\u578bID") String type, @PathVariable @Parameter(description="\u670d\u52a1\u5546ID") String provider) {
        return Flux.fromIterable(this.providers).filter(prov -> prov.getType().getId().equalsIgnoreCase(type) && prov.getProvider().getId().equalsIgnoreCase(provider)).flatMap(prov -> Mono.justOrEmpty((Object)prov.getNotifierConfigMetadata())).next();
    }

    @GetMapping(value={"/types"})
    @QueryAction
    @Operation(summary="\u83b7\u53d6\u5e73\u53f0\u652f\u6301\u7684\u901a\u77e5\u7c7b\u578b")
    public Flux<NotifyTypeInfo> getAllTypes() {
        return Flux.fromIterable(this.providers).collect(Collectors.groupingBy(NotifierProvider::getType)).flatMapIterable(Map::entrySet).map(en -> {
            NotifyTypeInfo typeInfo = new NotifyTypeInfo();
            typeInfo.setId(((NotifyType)en.getKey()).getId());
            typeInfo.setName(((NotifyType)en.getKey()).getName());
            typeInfo.setProviderInfos(((List)en.getValue()).stream().map(ProviderInfo::of).collect(Collectors.toList()));
            return typeInfo;
        });
    }

    @GetMapping(value={"/type/{type}/providers"})
    @QueryAction
    @Operation(summary="\u83b7\u53d6\u652f\u6301\u7684\u670d\u52a1\u5546")
    public Flux<ProviderInfo> getTypeProviders(@PathVariable @Parameter(description="\u901a\u77e5\u7c7b\u578bID") String type) {
        return Flux.fromIterable(this.providers).filter(provider -> provider.getType().getId().equals(type)).map(ProviderInfo::of);
    }

    public static class ProviderInfo {
        @Parameter(description="\u901a\u77e5\u7c7b\u578b")
        private final String type;
        @Parameter(description="\u670d\u52a1\u5546ID")
        private final String id;
        @Parameter(description="\u670d\u52a1\u5546\u540d\u79f0")
        private final String name;

        public static ProviderInfo of(NotifierProvider provider) {
            return new ProviderInfo(provider.getType().getId(), provider.getProvider().getId(), provider.getProvider().getName());
        }

        public ProviderInfo(String type, String id, String name) {
            this.type = type;
            this.id = id;
            this.name = name;
        }

        public String getType() {
            return this.type;
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class NotifyTypeInfo {
        @Parameter(description="\u901a\u77e5\u7c7b\u578bID")
        private String id;
        @Parameter(description="\u901a\u77e5\u7c7b\u578b\u540d\u79f0")
        private String name;
        @Parameter(description="\u670d\u52a1\u5546\u4fe1\u606f")
        private List<ProviderInfo> providerInfos;

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public List<ProviderInfo> getProviderInfos() {
            return this.providerInfos;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setProviderInfos(List<ProviderInfo> providerInfos) {
            this.providerInfos = providerInfos;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof NotifyTypeInfo)) {
                return false;
            }
            NotifyTypeInfo other = (NotifyTypeInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            return !(this$id == null ? other$id != null : !this$id.equals(other$id));
        }

        protected boolean canEqual(Object other) {
            return other instanceof NotifyTypeInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            return result;
        }
    }
}

