/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.manager.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Map;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.id.IDGenerator;
import org.jetlinks.community.notify.event.SerializableNotifierEvent;
import org.jetlinks.community.notify.manager.enums.NotifyState;

public class NotifyHistory {
    @Schema(description="ID")
    private String id;
    @Schema(description="\u901a\u77e5ID")
    private String notifierId;
    @Schema(description="\u72b6\u6001")
    private NotifyState state;
    @Schema(description="\u9519\u8bef\u7c7b\u578b")
    private String errorType;
    @Schema(description="\u5f02\u5e38\u6808")
    private String errorStack;
    @Schema(description="\u6a21\u7248ID")
    private String templateId;
    @Schema(description="\u6a21\u7248\u5185\u5bb9")
    private String template;
    @Schema(description="\u4e0a\u4e0b\u6587")
    private Map<String, Object> context;
    @Schema(description="\u670d\u52a1\u5546")
    private String provider;
    @Schema(description="\u901a\u77e5\u7c7b\u578b")
    private String notifyType;
    @Schema(description="\u901a\u77e5\u65f6\u95f4")
    private Long notifyTime;

    public static NotifyHistory of(SerializableNotifierEvent event) {
        NotifyHistory history = (NotifyHistory)FastBeanCopier.copy((Object)event, (Object)new NotifyHistory(), (String[])new String[0]);
        history.setId((String)IDGenerator.SNOW_FLAKE_STRING.generate());
        history.setNotifyTime(System.currentTimeMillis());
        if (null != event.getTemplate()) {
            history.setTemplate(JSON.toJSONString((Object)event.getTemplate()));
        }
        if (event.isSuccess()) {
            history.setState(NotifyState.success);
        } else {
            history.setErrorStack(event.getCause());
            history.setState(NotifyState.error);
        }
        return history;
    }

    public JSONObject toJson() {
        JSONObject obj = (JSONObject)FastBeanCopier.copy((Object)this, (Object)new JSONObject(), (String[])new String[0]);
        obj.put("state", (Object)this.state.getValue());
        obj.put("context", (Object)JSON.toJSONString(this.context));
        return obj;
    }

    public String getId() {
        return this.id;
    }

    public String getNotifierId() {
        return this.notifierId;
    }

    public NotifyState getState() {
        return this.state;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public String getErrorStack() {
        return this.errorStack;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    public String getTemplate() {
        return this.template;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public String getProvider() {
        return this.provider;
    }

    public String getNotifyType() {
        return this.notifyType;
    }

    public Long getNotifyTime() {
        return this.notifyTime;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setNotifierId(String notifierId) {
        this.notifierId = notifierId;
    }

    public void setState(NotifyState state) {
        this.state = state;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    public void setErrorStack(String errorStack) {
        this.errorStack = errorStack;
    }

    public void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public void setTemplate(String template) {
        this.template = template;
    }

    public void setContext(Map<String, Object> context) {
        this.context = context;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setNotifyType(String notifyType) {
        this.notifyType = notifyType;
    }

    public void setNotifyTime(Long notifyTime) {
        this.notifyTime = notifyTime;
    }
}

