/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.web.excel;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.validation.constraints.NotBlank;
import org.apache.commons.lang3.StringUtils;
import org.hswebframework.reactor.excel.CellDataType;
import org.hswebframework.reactor.excel.ExcelHeader;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.dict.EnumDict;
import org.hswebframework.web.exception.BusinessException;
import org.hswebframework.web.exception.ValidationException;
import org.hswebframework.web.validator.ValidatorUtils;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.ConfigPropertyMetadata;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.SimplePropertyMetadata;
import org.jetlinks.core.metadata.types.ArrayType;
import org.jetlinks.core.metadata.types.DataTypes;
import org.jetlinks.core.metadata.types.DoubleType;
import org.jetlinks.core.metadata.types.EnumType;
import org.jetlinks.core.metadata.types.FileType;
import org.jetlinks.core.metadata.types.FloatType;
import org.jetlinks.core.metadata.types.IntType;
import org.jetlinks.core.metadata.types.LongType;
import org.jetlinks.core.metadata.types.ObjectType;
import org.jetlinks.core.metadata.types.PasswordType;
import org.jetlinks.core.metadata.types.StringType;
import org.jetlinks.core.metadata.unit.ValueUnit;
import org.jetlinks.core.metadata.unit.ValueUnits;
import org.jetlinks.supports.official.JetLinksDataTypeCodecs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;

public class PropertyMetadataExcelInfo {
    private static final Logger log = LoggerFactory.getLogger(PropertyMetadataExcelInfo.class);
    @NotBlank(message="\u5c5e\u6027ID\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotBlank(message="\u5c5e\u6027ID\u4e0d\u80fd\u4e3a\u7a7a") String property;
    @NotBlank(message="\u5c5e\u6027\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotBlank(message="\u5c5e\u6027\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") String name;
    private String valueType;
    private Map<String, Object> expands;
    @NotBlank(message="\u6570\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotBlank(message="\u6570\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a") String dataType;
    private String unit;
    private String scale;
    @NotBlank(message="\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotBlank(message="\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a") String source;
    private String description;
    private String storageType;
    private long rowNumber;
    private List<String> type;
    private static final List<ValueUnit> idList = ValueUnits.getAllUnit();
    private static final List<String> DATA_TYPES = Lists.newArrayList((Object[])new String[]{"array", "boolean", "date", "double", "enum", "float", "int", "long", "object", "string", "geoPoint", "file", "password", "geoShape"});
    private static final List<String> OBJECT_NOT_HAVE = Lists.newArrayList((Object[])new String[]{"date", "file", "object", "password"});
    private static final List<String> SIMPLE = Lists.newArrayList((Object[])new String[]{"int", "float", "double", "long"});

    public void with(String key, Object value) {
        FastBeanCopier.copy(Collections.singletonMap(key, value), (Object)this, (String[])new String[0]);
    }

    public PropertyMetadata toMetadata() {
        SimplePropertyMetadata metadata = new SimplePropertyMetadata();
        try {
            ValidatorUtils.tryValidate((Object)this, (Class[])new Class[0]);
            if (CollectionUtils.isEmpty(this.type) || this.type.size() == 1 && StringUtils.isEmpty((CharSequence)this.type.get(0))) {
                throw new ValidationException("\u8bfb\u5199\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
            }
            metadata.setId(this.property);
            metadata.setName(this.name);
            metadata.setValueType(this.parseDataType());
            metadata.setExpands(this.parseExpands());
            metadata.setDescription(this.description);
            return metadata;
        }
        catch (Throwable e) {
            throw new BusinessException("\u7b2c" + this.getRowNumber() + "\u884c\u9519\u8bef\uff1a" + e.getMessage());
        }
    }

    public static List<ExcelHeader> getTemplateHeaderMapping(List<ConfigMetadata> configMetadataList) {
        ArrayList<ExcelHeader> arr = new ArrayList<ExcelHeader>(Arrays.asList(new ExcelHeader("property", "\u5c5e\u6027ID", CellDataType.STRING), new ExcelHeader("name", "\u5c5e\u6027\u540d\u79f0", CellDataType.STRING), new ExcelHeader("dataType", "\u6570\u636e\u7c7b\u578b", CellDataType.STRING), new ExcelHeader("unit", "\u5355\u4f4d", CellDataType.STRING), new ExcelHeader("scale", "\u7cbe\u5ea6", CellDataType.STRING), new ExcelHeader("valueType", "\u6570\u636e\u7c7b\u578b\u914d\u7f6e", CellDataType.STRING), new ExcelHeader("source", "\u6765\u6e90", CellDataType.STRING), new ExcelHeader("description", "\u5c5e\u6027\u8bf4\u660e", CellDataType.STRING), new ExcelHeader("type", "\u8bfb\u5199\u7c7b\u578b", CellDataType.STRING)));
        HashSet<String> expandsKeys = new HashSet<String>();
        for (ConfigMetadata configMetadata : configMetadataList) {
            for (ConfigPropertyMetadata property : configMetadata.getProperties()) {
                String header = property.getName();
                if (expandsKeys.contains(header)) {
                    header = configMetadata.getName() + "-" + header;
                }
                arr.add(new ExcelHeader("expands." + property.getProperty(), header, CellDataType.STRING));
                expandsKeys.add(property.getName());
            }
        }
        return arr;
    }

    protected DataType parseDataType() {
        JSONObject dataTypeJson = new JSONObject();
        if (!StringUtils.isEmpty((CharSequence)this.valueType)) {
            dataTypeJson = JSON.parseObject((String)this.valueType);
            this.dataType = dataTypeJson.getString("type");
        } else {
            dataTypeJson.put("type", (Object)this.dataType);
            dataTypeJson.put("unit", (Object)this.unit);
            dataTypeJson.put("scale", (Object)this.scale);
        }
        DataType dataType = Optional.ofNullable(this.dataType).map(DataTypes::lookup).map(Supplier::get).orElseThrow(() -> new BusinessException("error.unknown_data_type", 500, new Object[]{this, this.getDataType()}));
        JSONObject finalDataTypeJson = dataTypeJson;
        JetLinksDataTypeCodecs.getCodec((String)dataType.getId()).ifPresent(codec -> codec.decode(dataType, (Map)finalDataTypeJson));
        return dataType;
    }

    protected Map<String, Object> parseExpands() {
        HashMap<String, Object> map = new HashMap<String, Object>(4);
        map.put("source", PropertySource.getValue(this.source));
        map.put("storageType", PropertyStorage.getValue(this.storageType));
        map.put("tags", "");
        map.put("type", this.type.stream().map(PropertyType::getValue).collect(Collectors.toList()));
        return map;
    }

    public static Flux<PropertyMetadataExcelInfo> getTemplateContentMapping() {
        return Flux.fromIterable(DATA_TYPES).flatMap(dt -> {
            PropertyMetadataExcelInfo excelInfo = new PropertyMetadataExcelInfo();
            DataType dataType = (DataType)DataTypes.lookup((String)dt).get();
            excelInfo.setProperty(dataType.getType() + "_id");
            excelInfo.setName(dataType.getType() + "\u7c7b\u578b\u5c5e\u6027\u793a\u4f8b");
            excelInfo.setDataType(dataType.getId());
            excelInfo.setUnit("");
            excelInfo.setScale("");
            Random random = new Random();
            excelInfo.setStorageType(random.nextBoolean() ? "direct" : "ignore");
            excelInfo.setSource(random.nextInt(2) == 1 ? "manual" : (random.nextInt(2) < 1 ? "device" : "rule"));
            excelInfo.setDescription(excelInfo.getName() + "\u7684\u8bf4\u660e");
            if (SIMPLE.contains(dt)) {
                excelInfo.setUnit(idList.get(0).getId());
                excelInfo.setDataType((String)dt);
                excelInfo.setScale(String.valueOf(random.nextInt(2)));
                excelInfo.setDescription(excelInfo.getName() + "\u7684\u8bf4\u660e,\u4f18\u5148\u4f7f\u7528json\u6570\u636e\u7c7b\u578b\u914d\u7f6e\uff0c\u6ca1\u6709\u5219\u4f7f\u7528\u7b80\u5355\u6a21\u677f\uff0c\u4ec5\u652f\u6301int double float long\u56db\u79cd");
            }
            Map valueType = JetLinksDataTypeCodecs.encode((DataType)PropertyMetadataExcelInfo.buildValueType(dataType, random)).orElse(Collections.emptyMap());
            excelInfo.setValueType(JSONObject.toJSONString(valueType));
            excelInfo.setExpands(Collections.singletonMap("storageType", excelInfo.getStorageType()));
            excelInfo.setType(Arrays.asList("read", "write", "report"));
            return Flux.just((Object)excelInfo);
        }).doOnError(e -> log.error("\u586b\u5145\u6a21\u677f\u5f02\u5e38:", e));
    }

    private static DataType buildValueType(DataType dataType, Random random) {
        switch (dataType.getId()) {
            case "array": {
                ((ArrayType)dataType).elementType((DataType)new IntType().unit(idList.get(random.nextInt(idList.size() - 1))));
                break;
            }
            case "double": {
                ((DoubleType)dataType).scale(Integer.valueOf(random.nextInt(10))).unit(idList.get(random.nextInt(idList.size() - 1)));
                break;
            }
            case "float": {
                ((FloatType)dataType).scale(Integer.valueOf(random.nextInt(10))).unit(idList.get(random.nextInt(idList.size() - 1)));
                break;
            }
            case "enum": {
                dataType = new EnumType();
                for (int i = 0; i < random.nextInt(5); ++i) {
                    ((EnumType)dataType).addElement(EnumType.Element.of((String)("\u679a\u4e3e\u503c" + i), (String)String.valueOf(i), (String)("\u679a\u4e3e\u8bf4\u660e" + i)));
                }
                break;
            }
            case "int": {
                dataType = new IntType();
                ((IntType)dataType).unit(idList.get(random.nextInt(idList.size() - 1)));
                break;
            }
            case "long": {
                ((LongType)dataType).unit(idList.get(random.nextInt(idList.size() - 1)));
                break;
            }
            case "file": {
                ((FileType)dataType).bodyType(FileType.BodyType.url);
                break;
            }
            case "object": {
                int i = 1;
                CopyOnWriteArrayList objectParam = Lists.newCopyOnWriteArrayList(DATA_TYPES);
                dataType = new ObjectType();
                objectParam.removeAll(OBJECT_NOT_HAVE);
                for (String id : objectParam) {
                    ((ObjectType)dataType).addProperty("param" + i, "\u53c2\u6570" + i, PropertyMetadataExcelInfo.buildValueType((DataType)DataTypes.lookup((String)id).get(), random));
                    ++i;
                }
                break;
            }
            case "string": {
                ((StringType)dataType).expand("maxLength", (Object)random.nextInt(2000));
                break;
            }
            case "password": {
                ((PasswordType)dataType).expand("maxLength", (Object)random.nextInt(30));
                break;
            }
        }
        return dataType;
    }

    public Map<String, Object> toMap() {
        this.setSource(PropertySource.getText(this.source));
        this.setStorageType(PropertyStorage.getText(this.storageType));
        this.setExpands(Collections.singletonMap("storageType", this.storageType));
        Map map = (Map)FastBeanCopier.copy((Object)this, new HashMap(8), (String[])new String[0]);
        map.put("type", this.type.stream().map(PropertyType::getText).collect(Collectors.joining(",")));
        return map;
    }

    public String getProperty() {
        return this.property;
    }

    public String getName() {
        return this.name;
    }

    public String getValueType() {
        return this.valueType;
    }

    public Map<String, Object> getExpands() {
        return this.expands;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getUnit() {
        return this.unit;
    }

    public String getScale() {
        return this.scale;
    }

    public String getSource() {
        return this.source;
    }

    public String getDescription() {
        return this.description;
    }

    public String getStorageType() {
        return this.storageType;
    }

    public long getRowNumber() {
        return this.rowNumber;
    }

    public List<String> getType() {
        return this.type;
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValueType(String valueType) {
        this.valueType = valueType;
    }

    public void setExpands(Map<String, Object> expands) {
        this.expands = expands;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public void setScale(String scale) {
        this.scale = scale;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setStorageType(String storageType) {
        this.storageType = storageType;
    }

    public void setRowNumber(long rowNumber) {
        this.rowNumber = rowNumber;
    }

    public void setType(List<String> type) {
        this.type = type;
    }

    private static enum PropertyStorage implements EnumDict<String>
    {
        direct("\u5b58\u50a8"),
        ignore("\u4e0d\u5b58\u50a8");

        private String text;

        public String getValue() {
            return this.name();
        }

        public static String getText(String value) {
            return EnumDict.findByValue(PropertyStorage.class, (Object)value).map(PropertyStorage::getText).orElse("");
        }

        public static String getValue(String text) {
            return EnumDict.findByText(PropertyStorage.class, (String)text).map(PropertyStorage::getValue).orElse("");
        }

        private PropertyStorage(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }

    private static enum PropertyType implements EnumDict<String>
    {
        read("\u8bfb"),
        write("\u5199"),
        report("\u4e0a\u62a5");

        private String text;

        public String getValue() {
            return this.name();
        }

        public static String getText(String value) {
            return EnumDict.findByValue(PropertyType.class, (Object)value).map(PropertyType::getText).orElse("");
        }

        public static String getValue(String text) {
            return EnumDict.findByText(PropertyType.class, (String)text).map(PropertyType::getValue).orElse("");
        }

        private PropertyType(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }

    private static enum PropertySource implements EnumDict<String>
    {
        device("\u8bbe\u5907"),
        manual("\u624b\u52a8"),
        rule("\u89c4\u5219");

        private String text;

        public String getValue() {
            return this.name();
        }

        public static String getText(String value) {
            return EnumDict.findByValue(PropertySource.class, (Object)value).map(PropertySource::getText).orElse("");
        }

        public static String getValue(String text) {
            return EnumDict.findByText(PropertySource.class, (String)text).map(PropertySource::getValue).orElse("");
        }

        private PropertySource(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }
}

