/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.web;

import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.ezorm.core.StaticMethodReferenceColumn;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.ReactiveUpdate;
import org.hswebframework.web.api.crud.entity.PagerResult;
import org.hswebframework.web.api.crud.entity.QueryOperation;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.hswebframework.web.authorization.annotation.QueryAction;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.authorization.annotation.SaveAction;
import org.jetlinks.community.device.entity.DeviceInstanceEntity;
import org.jetlinks.community.device.entity.DeviceProductEntity;
import org.jetlinks.community.device.enums.DeviceType;
import org.jetlinks.community.device.service.LocalDeviceInstanceService;
import org.jetlinks.community.device.service.LocalDeviceProductService;
import org.jetlinks.community.device.web.response.GatewayDeviceInfo;
import org.jetlinks.core.config.ConfigKey;
import org.jetlinks.core.device.DeviceConfigKey;
import org.jetlinks.core.device.DeviceRegistry;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/device/gateway"})
@Resource(id="device-gateway", name="\u7f51\u5173\u8bbe\u5907\u7ba1\u7406")
@Tag(name="\u7f51\u5173\u8bbe\u5907\u7ba1\u7406")
public class GatewayDeviceController {
    @Autowired
    private LocalDeviceInstanceService instanceService;
    @Autowired
    private LocalDeviceProductService productService;
    @Autowired
    private DeviceRegistry registry;

    private Mono<List<String>> getGatewayProductList() {
        return ((ReactiveQuery)((ReactiveQuery)this.productService.createQuery().select(new StaticMethodReferenceColumn[]{DeviceProductEntity::getId})).where(DeviceProductEntity::getDeviceType, (Object)DeviceType.gateway)).fetch().map(DeviceProductEntity::getId).collectList().filter(CollectionUtils::isNotEmpty);
    }

    @GetMapping(value={"/_query"})
    @QueryAction
    @QueryOperation(summary="\u67e5\u8be2\u7f51\u5173\u8bbe\u5907\u8be6\u60c5")
    public Mono<PagerResult<GatewayDeviceInfo>> queryGatewayDevice(@Parameter(hidden=true) QueryParamEntity param) {
        return this.getGatewayProductList().flatMap(productIdList -> ((Mono)param.toNestQuery(query -> {
            Query cfr_ignored_0 = (Query)query.in(DeviceInstanceEntity::getProductId, (Collection)productIdList);
        }).execute(arg_0 -> ((LocalDeviceInstanceService)this.instanceService).queryPager(arg_0))).filter(r -> r.getTotal() > 0).flatMap(result -> {
            Map mapping = result.getData().stream().collect(Collectors.toMap(DeviceInstanceEntity::getId, Function.identity()));
            return ((ReactiveQuery)((ReactiveQuery)this.instanceService.createQuery().where()).in(DeviceInstanceEntity::getParentId, mapping.keySet())).fetch().groupBy(DeviceInstanceEntity::getParentId, Integer.MAX_VALUE).flatMap(group -> {
                String parentId = (String)group.key();
                return group.collectList().map(children -> GatewayDeviceInfo.of((DeviceInstanceEntity)((Object)((Object)((Object)((Object)((Object)mapping.get(parentId)))))), children));
            }).collectMap(GatewayDeviceInfo::getId).defaultIfEmpty(Collections.emptyMap()).flatMapMany(map -> Flux.fromIterable(mapping.values()).flatMap(ins -> Mono.justOrEmpty(map.get(ins.getId())).switchIfEmpty(Mono.fromSupplier(() -> GatewayDeviceInfo.of(ins, Collections.emptyList()))))).collectList().map(list -> PagerResult.of((int)result.getTotal(), (List)list, (QueryParam)param));
        })).defaultIfEmpty((Object)PagerResult.empty());
    }

    @GetMapping(value={"/{id}"})
    @QueryAction
    @QueryOperation(summary="\u83b7\u53d6\u5355\u4e2a\u7f51\u5173\u8bbe\u5907\u8be6\u60c5")
    public Mono<GatewayDeviceInfo> getGatewayInfo(@PathVariable String id) {
        return Mono.zip((Mono)this.instanceService.findById(id), (Mono)((ReactiveQuery)((ReactiveQuery)this.instanceService.createQuery().where()).is(DeviceInstanceEntity::getParentId, (Object)id)).fetch().collectList().defaultIfEmpty(Collections.emptyList()), GatewayDeviceInfo::of);
    }

    @PostMapping(value={"/{gatewayId}/bind/{deviceId}"})
    @SaveAction
    @QueryOperation(summary="\u7ed1\u5b9a\u5355\u4e2a\u5b50\u8bbe\u5907\u5230\u7f51\u5173\u8bbe\u5907")
    public Mono<GatewayDeviceInfo> bindDevice(@PathVariable @Parameter(description="\u7f51\u5173\u8bbe\u5907ID") String gatewayId, @PathVariable @Parameter(description="\u5b50\u8bbe\u5907ID") String deviceId) {
        return this.instanceService.checkCyclicDependency(deviceId, gatewayId).then(((ReactiveUpdate)((ReactiveUpdate)this.instanceService.createUpdate().set(DeviceInstanceEntity::getParentId, (Object)gatewayId)).where(DeviceInstanceEntity::getId, (Object)deviceId)).execute().then(this.registry.getDevice(deviceId).flatMap(operator -> operator.setConfig((ConfigKey)DeviceConfigKey.parentGatewayId, (Object)gatewayId))).then(this.registry.getDevice(gatewayId).flatMap(gwOperator -> gwOperator.getProtocol().flatMap(protocolSupport -> protocolSupport.onChildBind(gwOperator, Flux.from((Publisher)this.registry.getDevice(deviceId))))))).then(this.getGatewayInfo(gatewayId));
    }

    @PostMapping(value={"/{gatewayId}/bind"})
    @SaveAction
    @QueryOperation(summary="\u7ed1\u5b9a\u591a\u4e2a\u5b50\u8bbe\u5907\u5230\u7f51\u5173\u8bbe\u5907")
    public Mono<GatewayDeviceInfo> bindDevice(@PathVariable @Parameter(description="\u7f51\u5173\u8bbe\u5907ID") String gatewayId, @RequestBody @Parameter(description="\u5b50\u8bbe\u5907ID\u96c6\u5408") Mono<List<String>> deviceId) {
        return deviceId.flatMapIterable(Function.identity()).flatMap(childId -> this.instanceService.checkCyclicDependency((String)childId, gatewayId).thenReturn(childId)).collectList().filter(CollectionUtils::isNotEmpty).flatMap(deviceIdList -> ((ReactiveUpdate)((ReactiveUpdate)((ReactiveUpdate)this.instanceService.createUpdate().set(DeviceInstanceEntity::getParentId, (Object)gatewayId)).where()).in(DeviceInstanceEntity::getId, (Collection)deviceIdList)).execute().then(Flux.fromIterable((Iterable)deviceIdList).flatMap(id -> this.registry.getDevice(id).flatMap(operator -> operator.setConfig((ConfigKey)DeviceConfigKey.parentGatewayId, (Object)gatewayId))).then()).then(this.registry.getDevice(gatewayId).flatMap(gwOperator -> gwOperator.getProtocol().flatMap(protocolSupport -> protocolSupport.onChildBind(gwOperator, Flux.fromIterable((Iterable)deviceIdList).flatMap(id -> this.registry.getDevice(id))))))).then(this.getGatewayInfo(gatewayId));
    }

    @PostMapping(value={"/{gatewayId}/unbind/{deviceId}"})
    @SaveAction
    @QueryOperation(summary="\u4ece\u7f51\u5173\u8bbe\u5907\u4e2d\u89e3\u7ed1\u5b50\u8bbe\u5907")
    public Mono<GatewayDeviceInfo> unBindDevice(@PathVariable @Parameter(description="\u7f51\u5173\u8bbe\u5907ID") String gatewayId, @PathVariable @Parameter(description="\u81ea\u8bbe\u5907ID") String deviceId) {
        return ((ReactiveUpdate)((ReactiveUpdate)((ReactiveUpdate)this.instanceService.createUpdate().setNull(DeviceInstanceEntity::getParentId)).where(DeviceInstanceEntity::getId, (Object)deviceId)).and(DeviceInstanceEntity::getParentId, (Object)gatewayId)).execute().filter(i -> i > 0).flatMap(i -> this.registry.getDevice(deviceId).flatMap(operator -> operator.removeConfig(DeviceConfigKey.parentGatewayId.getKey()))).then(this.registry.getDevice(gatewayId).flatMap(gwOperator -> gwOperator.getProtocol().flatMap(protocolSupport -> protocolSupport.onChildUnbind(gwOperator, Flux.from((Publisher)this.registry.getDevice(deviceId)))))).then(this.getGatewayInfo(gatewayId));
    }
}

