/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.device.entity;

import io.swagger.v3.oas.annotations.media.Schema;
import java.sql.JDBCType;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Index;
import javax.persistence.Table;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.hswebframework.ezorm.rdb.mapping.annotation.ColumnType;
import org.hswebframework.ezorm.rdb.mapping.annotation.DefaultValue;
import org.hswebframework.ezorm.rdb.mapping.annotation.EnumCodec;
import org.hswebframework.ezorm.rdb.mapping.annotation.JsonCodec;
import org.hswebframework.web.api.crud.entity.GenericEntity;
import org.hswebframework.web.api.crud.entity.RecordCreationEntity;
import org.hswebframework.web.crud.annotation.EnableEntityEvent;
import org.hswebframework.web.utils.DigestUtils;
import org.hswebframework.web.validator.CreateGroup;
import org.jetlinks.core.things.ThingMetadataType;
import org.springframework.util.StringUtils;

@Table(name="dev_metadata_mapping", indexes={@Index(name="idx_dev_mmp_did", columnList="device_id"), @Index(name="idx_dev_mmp_pid", columnList="product_id")})
@Schema(description="\u8bbe\u5907\u7269\u6a21\u578b\u6620\u5c04")
@EnableEntityEvent
public class DeviceMetadataMappingEntity
extends GenericEntity<String>
implements RecordCreationEntity {
    @Schema(description="\u4ea7\u54c1ID")
    @Column(length=64, nullable=false, updatable=false)
    @NotBlank(groups={CreateGroup.class})
    private String productId;
    @Schema(description="\u8bbe\u5907ID,\u4e3a\u7a7a\u65f6\u8868\u793a\u6620\u5c04\u5bf9\u4ea7\u54c1\u4e0b\u6240\u6709\u8bbe\u5907\u751f\u6548")
    @Column(length=64, updatable=false)
    @NotBlank
    private String deviceId;
    @Schema(description="\u7269\u6a21\u578b\u7c7b\u578b,\u5982:property")
    @Column(length=32, nullable=false, updatable=false)
    @DefaultValue(value="property")
    @NotNull(groups={CreateGroup.class})
    @EnumCodec
    @ColumnType(javaType=String.class)
    private ThingMetadataType metadataType;
    @Schema(description="\u7269\u6a21\u578bID,\u5982:\u5c5e\u6027ID")
    @Column(length=64, nullable=false, updatable=false)
    @NotBlank(groups={CreateGroup.class})
    private String metadataId;
    @Schema(description="\u539f\u59cb\u7269\u6a21\u578bID")
    @Column(length=64, nullable=false)
    @NotBlank(groups={CreateGroup.class})
    private String originalId;
    @Schema(description="\u5176\u4ed6\u914d\u7f6e")
    @Column
    @JsonCodec
    @ColumnType(jdbcType=JDBCType.LONGVARCHAR)
    private Map<String, Object> others;
    @Schema(description="\u8bf4\u660e")
    @Column(length=512)
    private String description;
    @Schema(description="\u521b\u5efa\u8005ID", accessMode=Schema.AccessMode.READ_ONLY)
    @Column(length=64, updatable=false)
    private String creatorId;
    @Schema(description="\u521b\u5efa\u65f6\u95f4", accessMode=Schema.AccessMode.READ_ONLY)
    @Column(updatable=false)
    @DefaultValue(generator="current_time")
    private Long createTime;

    public String getId() {
        if (super.getId() == null) {
            this.generateId();
        }
        return (String)super.getId();
    }

    public void generateId() {
        if (StringUtils.hasText((String)this.deviceId)) {
            this.setId(DeviceMetadataMappingEntity.generateIdByDevice(this.deviceId, this.metadataType, this.metadataId));
        } else if (StringUtils.hasText((String)this.productId)) {
            this.setId(DeviceMetadataMappingEntity.generateIdByProduct(this.productId, this.metadataType, this.metadataId));
        }
    }

    public static String generateIdByProduct(String productId, ThingMetadataType type, String metadataId) {
        return DigestUtils.md5Hex((String)String.join((CharSequence)":", "product", productId, type.name(), metadataId));
    }

    public static String generateIdByDevice(String deviceId, ThingMetadataType type, String metadataId) {
        return DigestUtils.md5Hex((String)String.join((CharSequence)":", "device", deviceId, type.name(), metadataId));
    }

    public String getProductId() {
        return this.productId;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    @NotNull(groups={CreateGroup.class})
    public ThingMetadataType getMetadataType() {
        return this.metadataType;
    }

    public String getMetadataId() {
        return this.metadataId;
    }

    public String getOriginalId() {
        return this.originalId;
    }

    public Map<String, Object> getOthers() {
        return this.others;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public void setProductId(String productId) {
        this.productId = productId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public void setMetadataType(@NotNull(groups={CreateGroup.class}) ThingMetadataType metadataType) {
        this.metadataType = metadataType;
    }

    public void setMetadataId(String metadataId) {
        this.metadataId = metadataId;
    }

    public void setOriginalId(String originalId) {
        this.originalId = originalId;
    }

    public void setOthers(Map<String, Object> others) {
        this.others = others;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }
}

