/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.auth.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.authorization.annotation.SaveAction;
import org.hswebframework.web.crud.web.reactive.ReactiveServiceCrudController;
import org.jetlinks.community.auth.entity.RoleEntity;
import org.jetlinks.community.auth.service.RoleService;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/role"})
@Resource(id="role", name="\u89d2\u8272\u7ba1\u7406")
@Tag(name="\u89d2\u8272\u7ba1\u7406")
public class RoleController
implements ReactiveServiceCrudController<RoleEntity, String> {
    private final RoleService service;

    @PostMapping(value={"/{roleId}/users/_bind"})
    @Operation(summary="\u7ed1\u5b9a\u7528\u6237")
    @SaveAction
    public Mono<Void> bindUser(@PathVariable String roleId, @RequestBody Mono<List<String>> userId) {
        return userId.flatMap(list -> this.service.bindUser((Collection<String>)list, (Collection<String>)Collections.singleton(roleId), false));
    }

    @PostMapping(value={"/{roleId}/users/_unbind"})
    @Operation(summary="\u89e3\u7ed1\u7528\u6237")
    @SaveAction
    public Mono<Void> unbindUser(@PathVariable String roleId, @RequestBody Mono<List<String>> userId) {
        return userId.flatMap(list -> this.service.unbindUser((Collection<String>)list, (Collection<String>)Collections.singleton(roleId)));
    }

    public RoleController(RoleService service) {
        this.service = service;
    }

    public RoleService getService() {
        return this.service;
    }
}

