/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.auth.entity;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.hswebframework.web.api.crud.entity.GenericTreeSortSupportEntity;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.community.auth.entity.MenuBindEntity;
import org.jetlinks.community.auth.entity.MenuEntity;

public class MenuView
extends GenericTreeSortSupportEntity<String> {
    @Schema(description="\u83dc\u5355\u6240\u6709\u8005")
    private String owner;
    @Schema(description="\u83dc\u5355\u540d\u79f0")
    private String name;
    @Schema(description="\u7f16\u7801")
    private String code;
    @Schema(description="\u56fe\u6807")
    private String icon;
    @Schema(description="URL")
    private String url;
    @Schema(description="\u7236\u8282\u70b9")
    private String parentId;
    @Schema(description="\u6309\u94ae")
    private List<ButtonView> buttons;
    @Schema(description="\u5176\u4ed6\u914d\u7f6e")
    private Map<String, Object> options;
    @Schema(description="\u5b50\u8282\u70b9")
    private List<MenuView> children;
    @Schema(description="\u521b\u5efa\u65f6\u95f4")
    private Long createTime;
    @Schema(description="\u6570\u636e\u6743\u9650\u8bf4\u660e")
    private String accessDescription;
    @Schema(description="\u662f\u5426\u5df2\u6388\u6743")
    private boolean granted;

    public MenuView withGranted(MenuView granted) {
        if (granted == null) {
            return this;
        }
        this.granted = true;
        this.options = granted.getOptions();
        return this.withGrantedButtons(granted.getButtons());
    }

    public MenuView withGrantedButtons(Collection<ButtonView> grantedButtons) {
        if (CollectionUtils.isEmpty(grantedButtons) || CollectionUtils.isEmpty(this.buttons)) {
            return this;
        }
        Map grantedButtonMap = grantedButtons.stream().collect(Collectors.toMap(ButtonView::getId, Function.identity(), (a, b) -> a));
        for (ButtonView button : this.buttons) {
            button.enabled = (button.granted = grantedButtonMap.containsKey(button.getId()));
        }
        return this;
    }

    public Optional<ButtonView> getButton(String id) {
        if (CollectionUtils.isEmpty(this.buttons)) {
            return Optional.empty();
        }
        return this.buttons.stream().filter(button -> Objects.equals(id, button.getId())).findFirst();
    }

    public void grantAll() {
        this.granted = true;
        if (CollectionUtils.isNotEmpty(this.getButtons())) {
            for (ButtonView button : this.getButtons()) {
                button.granted = true;
            }
        }
    }

    public void resetGrant() {
        this.granted = false;
        if (CollectionUtils.isNotEmpty(this.getButtons())) {
            for (ButtonView button : this.getButtons()) {
                button.granted = false;
            }
        }
    }

    public static MenuView of(MenuEntity entity) {
        return (MenuView)((Object)FastBeanCopier.copy((Object)((Object)entity), (Object)((Object)new MenuView()), (String[])new String[0]));
    }

    public static MenuView of(MenuEntity entity, List<MenuBindEntity> binds) {
        MenuView view = MenuView.of(entity);
        if (binds == null) {
            return view;
        }
        view.granted = true;
        if (MapUtils.isEmpty(view.getOptions())) {
            view.setOptions(new HashMap<String, Object>());
        }
        binds.sort(Comparator.comparing(MenuBindEntity::getPriority));
        LinkedHashMap<String, ButtonView> buttons = new LinkedHashMap<String, ButtonView>();
        for (MenuBindEntity bind : binds) {
            if (!bind.getMerge().booleanValue()) {
                view.setOptions(new HashMap<String, Object>());
                buttons.clear();
            }
            if (MapUtils.isNotEmpty(bind.getOptions())) {
                view.getOptions().putAll(bind.getOptions());
            }
            if (!CollectionUtils.isNotEmpty(bind.getButtons())) continue;
            for (ButtonView button : bind.getButtons()) {
                if (!button.isGranted()) continue;
                buttons.put(button.getId(), button);
            }
        }
        view.setButtons(new ArrayList<ButtonView>(buttons.values()));
        return view;
    }

    public String getOwner() {
        return this.owner;
    }

    public String getName() {
        return this.name;
    }

    public String getCode() {
        return this.code;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getUrl() {
        return this.url;
    }

    public String getParentId() {
        return this.parentId;
    }

    public List<ButtonView> getButtons() {
        return this.buttons;
    }

    public Map<String, Object> getOptions() {
        return this.options;
    }

    public List<MenuView> getChildren() {
        return this.children;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public String getAccessDescription() {
        return this.accessDescription;
    }

    public boolean isGranted() {
        return this.granted;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setIcon(String icon) {
        this.icon = icon;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public void setButtons(List<ButtonView> buttons) {
        this.buttons = buttons;
    }

    public void setOptions(Map<String, Object> options) {
        this.options = options;
    }

    public void setChildren(List<MenuView> children) {
        this.children = children;
    }

    public void setCreateTime(Long createTime) {
        this.createTime = createTime;
    }

    public void setAccessDescription(String accessDescription) {
        this.accessDescription = accessDescription;
    }

    public void setGranted(boolean granted) {
        this.granted = granted;
    }

    public static class ButtonView
    implements Serializable {
        private static final long serialVersionUID = 1L;
        @Schema(description="\u6309\u94aeID")
        private String id;
        @Schema(description="\u6309\u94ae\u540d\u79f0")
        private String name;
        @Schema(description="\u8bf4\u660e")
        private String description;
        @Schema(description="\u5176\u4ed6\u914d\u7f6e")
        private Map<String, Object> options;
        @Schema(description="\u662f\u5426\u542f\u7528")
        @Deprecated
        private boolean enabled;
        @Schema(description="\u662f\u5426\u5df2\u6388\u6743")
        private boolean granted;

        public static ButtonView of(String id, String name, String description, Map<String, Object> options) {
            return ButtonView.of(id, name, description, options, true, true);
        }

        public ButtonView copy() {
            return (ButtonView)FastBeanCopier.copy((Object)this, (Object)new ButtonView(), (String[])new String[0]);
        }

        public String getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        public Map<String, Object> getOptions() {
            return this.options;
        }

        @Deprecated
        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isGranted() {
            return this.granted;
        }

        public void setId(String id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public void setOptions(Map<String, Object> options) {
            this.options = options;
        }

        @Deprecated
        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setGranted(boolean granted) {
            this.granted = granted;
        }

        private ButtonView(String id, String name, String description, Map<String, Object> options, boolean enabled, boolean granted) {
            this.id = id;
            this.name = name;
            this.description = description;
            this.options = options;
            this.enabled = enabled;
            this.granted = granted;
        }

        public static ButtonView of(String id, String name, String description, Map<String, Object> options, boolean enabled, boolean granted) {
            return new ButtonView(id, name, description, options, enabled, granted);
        }

        public ButtonView() {
        }
    }
}

