/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.things.data;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.jetlinks.community.things.data.MetricMetadataManager;
import org.jetlinks.core.metadata.PropertyMetadata;

public class DefaultMetricMetadataManager
implements MetricMetadataManager {
    private final Map<String, Map<String, PropertyMetadata>> repo = new ConcurrentHashMap<String, Map<String, PropertyMetadata>>();

    @Override
    public void register(String metric, List<PropertyMetadata> properties) {
        this.repo.compute(metric, (key, old) -> {
            if (old != null) {
                old.clear();
            } else {
                old = new ConcurrentHashMap<String, PropertyMetadata>();
            }
            for (PropertyMetadata property : properties) {
                old.put(property.getId(), property);
            }
            return old;
        });
    }

    @Override
    public Optional<PropertyMetadata> getColumn(String metric, String property) {
        if (metric == null || property == null) {
            return Optional.empty();
        }
        Map<String, PropertyMetadata> m = this.repo.get(metric);
        if (m != null) {
            return Optional.ofNullable(m.get(property));
        }
        return Optional.empty();
    }
}

