/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.things.data;

import org.jetlinks.community.things.data.CacheSaveOperationsStrategy;
import org.jetlinks.community.things.data.ThingsDataRepositoryStrategy;
import org.jetlinks.community.things.data.operations.DDLOperations;
import org.jetlinks.community.things.data.operations.QueryOperations;
import org.jetlinks.community.things.data.operations.SaveOperations;
import org.jetlinks.community.things.data.operations.TemplateOperations;
import org.jetlinks.community.things.data.operations.ThingOperations;

public abstract class AbstractThingDataRepositoryStrategy
extends CacheSaveOperationsStrategy {
    @Override
    public abstract SaveOperations createOpsForSave(ThingsDataRepositoryStrategy.OperationsContext var1);

    protected abstract QueryOperations createForQuery(String var1, String var2, String var3, ThingsDataRepositoryStrategy.OperationsContext var4);

    protected abstract DDLOperations createForDDL(String var1, String var2, String var3, ThingsDataRepositoryStrategy.OperationsContext var4);

    @Override
    public final ThingOperations opsForThing(String thingType, String templateId, String thingId, ThingsDataRepositoryStrategy.OperationsContext context) {
        return new ThingOperationsHolder(thingType, templateId, thingId, context);
    }

    @Override
    public final TemplateOperations opsForTemplate(String thingType, String templateId, ThingsDataRepositoryStrategy.OperationsContext context) {
        return new ThingOperationsHolder(thingType, templateId, null, context);
    }

    class ThingOperationsHolder
    implements ThingOperations,
    TemplateOperations {
        private final String thingType;
        private final String templateId;
        private final String thingId;
        private final ThingsDataRepositoryStrategy.OperationsContext context;

        @Override
        public QueryOperations forQuery() {
            return AbstractThingDataRepositoryStrategy.this.createForQuery(this.thingType, this.templateId, this.thingId, this.context);
        }

        @Override
        public DDLOperations forDDL() {
            return AbstractThingDataRepositoryStrategy.this.createForDDL(this.thingType, this.templateId, this.thingId, this.context);
        }

        public ThingOperationsHolder(String thingType, String templateId, String thingId, ThingsDataRepositoryStrategy.OperationsContext context) {
            this.thingType = thingType;
            this.templateId = templateId;
            this.thingId = thingId;
            this.context = context;
        }
    }
}

