/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.things.data.operations;

import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.hswebframework.ezorm.core.dsl.Query;
import org.hswebframework.ezorm.core.param.QueryParam;
import org.hswebframework.web.api.crud.entity.PagerResult;
import org.hswebframework.web.api.crud.entity.QueryParamEntity;
import org.jetlinks.community.things.data.AggregationRequest;
import org.jetlinks.community.things.data.ThingPropertyDetail;
import org.jetlinks.community.things.data.operations.AbstractQueryOperations;
import org.jetlinks.community.things.data.operations.DataSettings;
import org.jetlinks.community.things.data.operations.MetricBuilder;
import org.jetlinks.community.timeseries.TimeSeriesData;
import org.jetlinks.community.timeseries.query.AggregationData;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.things.ThingMetadata;
import org.jetlinks.core.things.ThingsRegistry;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public abstract class RowModeQueryOperationsBase
extends AbstractQueryOperations {
    public RowModeQueryOperationsBase(String thingType, String thingTemplateId, String thingId, MetricBuilder metricBuilder, DataSettings settings, ThingsRegistry registry) {
        super(thingType, thingTemplateId, thingId, metricBuilder, settings, registry);
    }

    @Override
    protected final Flux<ThingPropertyDetail> queryProperty(@Nonnull QueryParamEntity param, @Nonnull ThingMetadata metadata, @Nonnull Map<String, PropertyMetadata> properties) {
        String metric = this.metricBuilder.createPropertyMetric(this.thingType, this.thingTemplateId, this.thingId);
        Query query = param.toNestQuery(q -> {
            this.applyQuery((Query<?, ? extends QueryParam>)q);
            q.in("property", properties.keySet());
        });
        return this.doQuery(metric, query).mapNotNull(data -> ThingPropertyDetail.of(data, (PropertyMetadata)properties.get(data.getString("property", null))));
    }

    @Override
    protected Flux<ThingPropertyDetail> queryEachProperty(@Nonnull String metric, @Nonnull Query<?, QueryParamEntity> query, @Nonnull ThingMetadata metadata, @Nonnull Map<String, PropertyMetadata> properties) {
        return Flux.fromIterable(properties.entrySet()).flatMap(e -> this.doQuery(metric, (Query)((QueryParamEntity)query.getParam()).clone().toQuery().and("property", e.getKey())).mapNotNull(data -> ThingPropertyDetail.of(data, (PropertyMetadata)properties.get(data.getString("property", null)))), 16);
    }

    @Override
    protected final Mono<PagerResult<ThingPropertyDetail>> queryPropertyPage(@Nonnull QueryParamEntity param, @Nonnull ThingMetadata metadata, @Nonnull Map<String, PropertyMetadata> properties) {
        String metric = this.metricBuilder.createPropertyMetric(this.thingType, this.thingTemplateId, this.thingId);
        Query query = param.toNestQuery(q -> {
            this.applyQuery((Query<?, ? extends QueryParam>)q);
            q.in("property", properties.keySet());
        });
        return this.doQueryPage(metric, query, data -> ThingPropertyDetail.of(data, (PropertyMetadata)properties.get(data.getString("property", null))));
    }

    @Override
    protected abstract Flux<TimeSeriesData> doQuery(String var1, Query<?, QueryParamEntity> var2);

    @Override
    protected abstract <T> Mono<PagerResult<T>> doQueryPage(String var1, Query<?, QueryParamEntity> var2, Function<TimeSeriesData, T> var3);

    @Override
    protected abstract Flux<AggregationData> doAggregation(String var1, AggregationRequest var2, AbstractQueryOperations.AggregationContext var3);
}

