/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.things.data;

import com.alibaba.fastjson.annotation.JSONField;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hswebframework.web.dict.I18nEnumDict;
import org.jetlinks.core.message.Message;
import org.jetlinks.core.message.MessageType;

@Generated
public enum ThingLogType implements I18nEnumDict<String>
{
    event("\u4e8b\u4ef6\u4e0a\u62a5"),
    readProperty("\u8bfb\u53d6\u5c5e\u6027"),
    writeProperty("\u4fee\u6539\u5c5e\u6027"),
    writePropertyReply("\u4fee\u6539\u5c5e\u6027\u56de\u590d"),
    reportProperty("\u5c5e\u6027\u4e0a\u62a5"),
    readPropertyReply("\u8bfb\u53d6\u5c5e\u6027\u56de\u590d"),
    child("\u5b50\u8bbe\u5907\u6d88\u606f"),
    childReply("\u5b50\u8bbe\u5907\u6d88\u606f\u56de\u590d"),
    functionInvoke("\u8c03\u7528\u529f\u80fd"),
    functionReply("\u8c03\u7528\u529f\u80fd\u56de\u590d"),
    register("\u8bbe\u5907\u6ce8\u518c"),
    unregister("\u8bbe\u5907\u6ce8\u9500"),
    readFirmware("\u8bfb\u53d6\u56fa\u4ef6\u4fe1\u606f"),
    readFirmwareReply("\u8bfb\u53d6\u56fa\u4ef6\u4fe1\u606f\u56de\u590d"),
    reportFirmware("\u4e0a\u62a5\u56fa\u4ef6\u4fe1\u606f"),
    pullFirmware("\u62c9\u53d6\u56fa\u4ef6\u4fe1\u606f"),
    pullFirmwareReply("\u62c9\u53d6\u56fa\u4ef6\u4fe1\u606f\u56de\u590d"),
    upgradeFirmware("\u63a8\u9001\u56fa\u4ef6\u4fe1\u606f"),
    upgradeFirmwareReply("\u63a8\u9001\u56fa\u4ef6\u4fe1\u606f\u56de\u590d"),
    upgradeFirmwareProgress("\u56fa\u4ef6\u66f4\u65b0\u8fdb\u5ea6"),
    log("\u65e5\u5fd7"),
    tag("\u6807\u7b7e\u66f4\u65b0"),
    offline("\u79bb\u7ebf"),
    online("\u4e0a\u7ebf"),
    other("\u5176\u5b83"),
    direct("\u900f\u4f20"),
    acknowledge("\u5e94\u7b54"),
    metadata("\u4e0a\u62a5\u7269\u6a21\u578b"),
    stateCheck("\u72b6\u6001\u68c0\u67e5"),
    stateCheckReply("\u72b6\u6001\u68c0\u67e5\u56de\u590d"),
    disconnect("\u65ad\u5f00\u8fde\u63a5"),
    disconnectReply("\u65ad\u5f00\u8fde\u63a5\u56de\u590d");

    @JSONField(serialize=false)
    private final String text;
    private static final Map<MessageType, ThingLogType> typeMapping;
    public static final List<String> nameList;

    public String getValue() {
        return this.name();
    }

    @Generated
    public static ThingLogType of(Message message) {
        return Optional.ofNullable(typeMapping.get(message.getMessageType())).orElse(other);
    }

    private ThingLogType(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    static {
        typeMapping = new EnumMap<MessageType, ThingLogType>(MessageType.class);
        nameList = Collections.unmodifiableList(Arrays.stream(ThingLogType.values()).map(Enum::name).collect(Collectors.toList()));
        typeMapping.put(MessageType.EVENT, event);
        typeMapping.put(MessageType.ONLINE, online);
        typeMapping.put(MessageType.OFFLINE, offline);
        typeMapping.put(MessageType.CHILD, child);
        typeMapping.put(MessageType.CHILD_REPLY, childReply);
        typeMapping.put(MessageType.LOG, log);
        typeMapping.put(MessageType.UPDATE_TAG, tag);
        typeMapping.put(MessageType.REPORT_PROPERTY, reportProperty);
        typeMapping.put(MessageType.READ_PROPERTY, readProperty);
        typeMapping.put(MessageType.READ_PROPERTY_REPLY, readPropertyReply);
        typeMapping.put(MessageType.INVOKE_FUNCTION, functionInvoke);
        typeMapping.put(MessageType.INVOKE_FUNCTION_REPLY, functionReply);
        typeMapping.put(MessageType.WRITE_PROPERTY, writeProperty);
        typeMapping.put(MessageType.WRITE_PROPERTY_REPLY, writePropertyReply);
        typeMapping.put(MessageType.REGISTER, register);
        typeMapping.put(MessageType.UN_REGISTER, unregister);
        typeMapping.put(MessageType.READ_FIRMWARE, readFirmware);
        typeMapping.put(MessageType.READ_FIRMWARE_REPLY, readFirmwareReply);
        typeMapping.put(MessageType.REPORT_FIRMWARE, reportFirmware);
        typeMapping.put(MessageType.REQUEST_FIRMWARE, pullFirmware);
        typeMapping.put(MessageType.REQUEST_FIRMWARE_REPLY, pullFirmwareReply);
        typeMapping.put(MessageType.UPGRADE_FIRMWARE, upgradeFirmware);
        typeMapping.put(MessageType.UPGRADE_FIRMWARE_REPLY, upgradeFirmwareReply);
        typeMapping.put(MessageType.UPGRADE_FIRMWARE_PROGRESS, upgradeFirmwareProgress);
        typeMapping.put(MessageType.ACKNOWLEDGE, acknowledge);
        typeMapping.put(MessageType.DERIVED_METADATA, metadata);
        typeMapping.put(MessageType.STATE_CHECK, stateCheck);
        typeMapping.put(MessageType.STATE_CHECK_REPLY, stateCheckReply);
        typeMapping.put(MessageType.DISCONNECT, disconnect);
        typeMapping.put(MessageType.DISCONNECT_REPLY, disconnectReply);
        typeMapping.put(MessageType.DIRECT, direct);
    }
}

