/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.executor;

import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import org.hswebframework.ezorm.rdb.executor.SqlRequests;
import org.hswebframework.ezorm.rdb.executor.reactive.ReactiveSqlExecutor;
import org.hswebframework.ezorm.rdb.executor.wrapper.ResultWrappers;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.utils.ExpressionUtils;
import org.jetlinks.rule.engine.api.RuleData;
import org.jetlinks.rule.engine.api.RuleDataHelper;
import org.jetlinks.rule.engine.api.model.NodeType;
import org.jetlinks.rule.engine.api.task.ExecutionContext;
import org.jetlinks.rule.engine.api.task.TaskExecutor;
import org.jetlinks.rule.engine.api.task.TaskExecutorProvider;
import org.jetlinks.rule.engine.defaults.LambdaTaskExecutor;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class SqlExecutorTaskExecutorProvider
implements TaskExecutorProvider {
    @Autowired
    private ReactiveSqlExecutor sqlExecutor;

    public String getExecutor() {
        return "sql";
    }

    public Function<RuleData, Publisher<?>> createExecutor(ExecutionContext context, Config config) {
        if (config.isQuery()) {
            return data -> Flux.defer(() -> {
                String sql = config.getSql((RuleData)data);
                ArrayList fluxes = new ArrayList();
                data.acceptMap(map -> fluxes.add(this.sqlExecutor.select((Publisher)Mono.just((Object)SqlRequests.template((String)sql, (Object)map)), ResultWrappers.map())));
                return Flux.concat(fluxes);
            });
        }
        return data -> Mono.defer(() -> {
            String sql = config.getSql((RuleData)data);
            ArrayList fluxes = new ArrayList();
            data.acceptMap(map -> fluxes.add(this.sqlExecutor.update((Publisher)Mono.just((Object)SqlRequests.template((String)sql, (Object)map)))));
            return Flux.concat(fluxes).reduce(Math::addExact);
        });
    }

    public Mono<TaskExecutor> createTask(ExecutionContext context) {
        return Mono.just((Object)new LambdaTaskExecutor("SQL", context, () -> this.createExecutor(context, (Config)FastBeanCopier.copy((Object)context.getJob().getConfiguration(), (Object)new Config(), (String[])new String[0]))));
    }

    public static class Config {
        private String dataSourceId;
        private NodeType nodeType = NodeType.MAP;
        private String sql;
        private boolean stream;
        private boolean transaction;

        public boolean isQuery() {
            return this.sql.trim().startsWith("SELECT") || this.sql.trim().startsWith("select");
        }

        public String getSql(RuleData data) {
            if (!this.sql.contains("${")) {
                return this.sql;
            }
            return ExpressionUtils.analytical((String)this.sql, (Map)RuleDataHelper.toContextMap((RuleData)data), (String)"spel");
        }

        public String getDataSourceId() {
            return this.dataSourceId;
        }

        public NodeType getNodeType() {
            return this.nodeType;
        }

        public String getSql() {
            return this.sql;
        }

        public boolean isStream() {
            return this.stream;
        }

        public boolean isTransaction() {
            return this.transaction;
        }

        public void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        public void setNodeType(NodeType nodeType) {
            this.nodeType = nodeType;
        }

        public void setSql(String sql) {
            this.sql = sql;
        }

        public void setStream(boolean stream) {
            this.stream = stream;
        }

        public void setTransaction(boolean transaction) {
            this.transaction = transaction;
        }
    }
}

