/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.executor;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.codec.digest.DigestUtils;
import org.hswebframework.expands.script.engine.DynamicScriptEngine;
import org.hswebframework.expands.script.engine.DynamicScriptEngineFactory;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.rule.engine.api.RuleData;
import org.jetlinks.rule.engine.api.task.ExecutionContext;
import org.jetlinks.rule.engine.api.task.TaskExecutor;
import org.jetlinks.rule.engine.api.task.TaskExecutorProvider;
import org.jetlinks.rule.engine.defaults.LambdaTaskExecutor;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
public class ScriptTaskExecutorProvider
implements TaskExecutorProvider {
    private static final Logger log = LoggerFactory.getLogger(ScriptTaskExecutorProvider.class);

    public String getExecutor() {
        return "script";
    }

    public Mono<TaskExecutor> createTask(ExecutionContext context) {
        return Mono.just((Object)new LambdaTaskExecutor("script", context, () -> this.createExecutor(context, (Config)FastBeanCopier.copy((Object)context.getJob().getConfiguration(), (Object)new Config(), (String[])new String[0]))));
    }

    public Function<RuleData, Publisher<?>> createExecutor(ExecutionContext context, Config config) {
        DynamicScriptEngine engine = DynamicScriptEngineFactory.getEngine((String)config.getLang());
        if (engine == null) {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u811a\u672c\u8bed\u8a00:" + config.getLang());
        }
        if (StringUtils.isEmpty((Object)config.getScript())) {
            log.warn("script is empty");
            return Mono::just;
        }
        String id = DigestUtils.md5Hex((String)config.getScript());
        if (!engine.compiled(id)) {
            engine.compile(id, config.getScript());
        }
        Handler handler = new Handler();
        HashMap<String, Object> scriptContext = new HashMap<String, Object>();
        scriptContext.put("context", context);
        scriptContext.put("handler", handler);
        engine.execute(id, scriptContext).getIfSuccess();
        return ruleData -> Flux.defer(() -> {
            if (handler.onMessage != null) {
                Object result = handler.onMessage.apply(ruleData);
                if (result == null || result.getClass().getName().equals("jdk.nashorn.internal.runtime.Undefined")) {
                    return Flux.empty();
                }
                if (result instanceof Publisher) {
                    return Flux.from((Publisher)((Publisher)result));
                }
                if (result instanceof Map) {
                    result = new HashMap((Map)result);
                }
                return Flux.just(result);
            }
            return Flux.empty();
        });
    }

    public static class Config {
        private String lang = "js";
        private String script;

        public String getLang() {
            return this.lang;
        }

        public String getScript() {
            return this.script;
        }

        public void setLang(String lang) {
            this.lang = lang;
        }

        public void setScript(String script) {
            this.script = script;
        }
    }

    public static class Handler {
        private Function<RuleData, Object> onMessage;

        public void onMessage(Function<RuleData, Object> onMessage) {
            this.onMessage = onMessage;
        }
    }
}

