/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.rule.engine.event.handler;

import org.jetlinks.community.elastic.search.index.ElasticIndex;
import org.jetlinks.community.elastic.search.service.ElasticSearchService;
import org.jetlinks.community.gateway.annotation.Subscribe;
import org.jetlinks.community.rule.engine.entity.RuleEngineExecuteEventInfo;
import org.jetlinks.community.rule.engine.event.handler.RuleEngineLoggerIndexProvider;
import org.jetlinks.core.event.TopicPayload;
import org.jetlinks.rule.engine.defaults.LogEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
@Order(value=3)
public class RuleLogHandler {
    private static final Logger log = LoggerFactory.getLogger(RuleLogHandler.class);
    @Autowired
    private ElasticSearchService elasticSearchService;

    @Subscribe(value={"/rule-engine/*/*/event/*"})
    public Mono<Void> handleEvent(TopicPayload event) {
        return this.elasticSearchService.commit((ElasticIndex)RuleEngineLoggerIndexProvider.RULE_EVENT_LOG, (Object)RuleEngineExecuteEventInfo.of(event));
    }

    @Subscribe(value={"/rule-engine/*/*/logger/*"})
    public Mono<Void> handleLog(LogEvent event) {
        return this.elasticSearchService.commit((ElasticIndex)RuleEngineLoggerIndexProvider.RULE_LOG, (Object)event);
    }
}

