/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.relation.impl;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.hswebframework.ezorm.core.StaticMethodReferenceColumn;
import org.hswebframework.ezorm.rdb.mapping.ReactiveQuery;
import org.hswebframework.ezorm.rdb.mapping.ReactiveRepository;
import org.jetlinks.community.relation.RelationObjectProvider;
import org.jetlinks.community.relation.entity.RelatedEntity;
import org.jetlinks.community.relation.impl.DefaultRelatedObject;
import org.jetlinks.core.things.relation.RelatedObject;
import org.jetlinks.core.things.relation.RelationOperation;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class DefaultRelationOperation
implements RelationOperation {
    final String type;
    final String id;
    final ReactiveRepository<RelatedEntity, String> relatedRepository;
    final Function<String, RelationObjectProvider> objectProvider;
    final boolean reverse;

    public Flux<RelatedObject> save(String type, String relation, Collection<String> targetId) {
        return Flux.empty();
    }

    public Mono<RelatedObject> save(String type, String relation, String targetId) {
        return Mono.empty();
    }

    public Mono<RelatedObject> get(String type, String relation, String targetId) {
        return this.get(type, relation, Collections.singleton(targetId)).singleOrEmpty();
    }

    public Flux<RelatedObject> get(String type, String relation, String ... targetId) {
        return this.get(type, relation, Arrays.asList(targetId));
    }

    public Flux<RelatedObject> get(String type, String relation, Collection<String> targetId) {
        return ((ReactiveQuery)((ReactiveQuery)((ReactiveQuery)this.relatedRepository.createQuery().where((StaticMethodReferenceColumn)(this.reverse ? RelatedEntity::getRelatedKey : RelatedEntity::getObjectKey), (Object)RelatedEntity.generateKey(this.type, this.id))).and(RelatedEntity::getRelation, (Object)relation)).when(CollectionUtils.isNotEmpty(targetId), query -> {
            ReactiveQuery cfr_ignored_0 = (ReactiveQuery)query.in((StaticMethodReferenceColumn)(this.reverse ? RelatedEntity::getObjectKey : RelatedEntity::getRelatedKey), (Collection)targetId.stream().map(id -> RelatedEntity.generateKey(type, id)).collect(Collectors.toSet()));
        })).fetch().map(this::toObject);
    }

    public Flux<RelatedObject> get(String type) {
        return this.get(type, null, Collections.emptyList());
    }

    private RelatedObject toObject(RelatedEntity entity) {
        if (this.reverse) {
            return new DefaultRelatedObject(entity.getObjectType(), entity.getObjectId(), this.type, this.id, entity.getRelation(), this.relatedRepository, this.objectProvider);
        }
        return new DefaultRelatedObject(entity.getRelatedType(), entity.getRelatedId(), this.type, this.id, entity.getRelation(), this.relatedRepository, this.objectProvider);
    }

    public DefaultRelationOperation(String type, String id, ReactiveRepository<RelatedEntity, String> relatedRepository, Function<String, RelationObjectProvider> objectProvider, boolean reverse) {
        this.type = type;
        this.id = id;
        this.relatedRepository = relatedRepository;
        this.objectProvider = objectProvider;
        this.reverse = reverse;
    }
}

