/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.wechat.corp;

import java.net.URI;
import java.time.Duration;
import javax.annotation.Nonnull;
import org.jetlinks.community.notify.AbstractNotifier;
import org.jetlinks.community.notify.DefaultNotifyType;
import org.jetlinks.community.notify.NotifyType;
import org.jetlinks.community.notify.Provider;
import org.jetlinks.community.notify.template.TemplateManager;
import org.jetlinks.community.notify.wechat.WechatProvider;
import org.jetlinks.community.notify.wechat.corp.WechatCorpProperties;
import org.jetlinks.community.notify.wechat.corp.WechatMessageTemplate;
import org.jetlinks.community.notify.wechat.corp.request.AccessTokenRequest;
import org.jetlinks.community.notify.wechat.corp.request.ApiRequest;
import org.jetlinks.community.notify.wechat.corp.request.NotifyRequest;
import org.jetlinks.community.notify.wechat.corp.response.AccessTokenResponse;
import org.jetlinks.community.notify.wechat.corp.response.ApiResponse;
import org.jetlinks.community.relation.RelationConstants;
import org.jetlinks.core.Values;
import org.jetlinks.core.command.Command;
import org.jetlinks.core.command.CommandSupport;
import org.jetlinks.core.config.ConfigKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import org.springframework.web.reactive.function.client.WebClient;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Mono;

public class WechatCorpNotifier
extends AbstractNotifier<WechatMessageTemplate>
implements CommandSupport,
ExchangeFilterFunction {
    private static final Logger log = LoggerFactory.getLogger(WechatCorpNotifier.class);
    private final WebClient apiClient;
    private final WechatCorpProperties properties;
    private final String notifierId;
    private volatile Mono<String> token;

    public WechatCorpNotifier(String id, WebClient.Builder builder, WechatCorpProperties properties, TemplateManager templateManager) {
        super(templateManager);
        this.apiClient = builder.clone().filter((ExchangeFilterFunction)this).baseUrl("https://qyapi.weixin.qq.com").build();
        this.properties = properties;
        this.notifierId = id;
    }

    @Nonnull
    public NotifyType getType() {
        return DefaultNotifyType.weixin;
    }

    @Nonnull
    public Provider getProvider() {
        return WechatProvider.corpMessage;
    }

    @Nonnull
    public Mono<Void> send(@Nonnull WechatMessageTemplate template, @Nonnull Values context) {
        String thirdPartyType = this.getType().getId() + "_" + this.getProvider().getId();
        String thirdPartyProvider = this.getNotifierId();
        ConfigKey relationPropertyPath = RelationConstants.UserProperty.thirdParty((String)thirdPartyType, (String)thirdPartyProvider);
        return template.createJsonRequest(context, (ConfigKey<String>)relationPropertyPath).flatMap(jsonRequest -> this.execute(new NotifyRequest(jsonRequest))).doOnNext(ApiResponse::assertSuccess).then();
    }

    @Nonnull
    public <R> R execute(@Nonnull Command<R> command) {
        if (command instanceof ApiRequest) {
            return (R)((ApiRequest)command).execute(this.apiClient);
        }
        throw new UnsupportedOperationException();
    }

    @Nonnull
    public Mono<Void> close() {
        this.token = null;
        return Mono.empty();
    }

    @Nonnull
    public Mono<ClientResponse> filter(@Nonnull ClientRequest request, @Nonnull ExchangeFunction next) {
        if (request.url().getPath().endsWith("gettoken")) {
            return next.exchange(request);
        }
        return this.getToken().flatMap(token -> next.exchange(ClientRequest.from((ClientRequest)request).url(UriComponentsBuilder.fromUri((URI)request.url()).queryParam("access_token", new Object[]{token}).build().toUri()).build()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Mono<String> getToken() {
        if (this.token == null) {
            WechatCorpNotifier wechatCorpNotifier = this;
            synchronized (wechatCorpNotifier) {
                if (this.token == null) {
                    this.token = this.requestToken().cache(val -> Duration.ofSeconds(Math.max(3600, val.getExpiresIn()) - 60), err -> Duration.ZERO, () -> Duration.ZERO).map(AccessTokenResponse::getAccessToken);
                }
            }
        }
        return this.token;
    }

    private Mono<AccessTokenResponse> requestToken() {
        return new AccessTokenRequest(this.properties.getCorpId(), this.properties.getCorpSecret()).execute(this.apiClient).doOnNext(AccessTokenResponse::assertSuccess);
    }

    public String getNotifierId() {
        return this.notifierId;
    }
}

