/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.webhook.http;

import javax.annotation.Nonnull;
import org.apache.commons.collections.CollectionUtils;
import org.jetlinks.community.notify.AbstractNotifier;
import org.jetlinks.community.notify.DefaultNotifyType;
import org.jetlinks.community.notify.NotifyType;
import org.jetlinks.community.notify.Provider;
import org.jetlinks.community.notify.template.TemplateManager;
import org.jetlinks.community.notify.webhook.WebHookProvider;
import org.jetlinks.community.notify.webhook.http.HttpWebHookProperties;
import org.jetlinks.community.notify.webhook.http.HttpWebHookTemplate;
import org.jetlinks.core.Values;
import org.springframework.http.HttpMethod;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;

public class HttpWebHookNotifier
extends AbstractNotifier<HttpWebHookTemplate> {
    private final String id;
    private final WebClient webClient;
    private final HttpWebHookProperties properties;

    public HttpWebHookNotifier(String id, HttpWebHookProperties properties, WebClient webClient, TemplateManager templateManager) {
        super(templateManager);
        this.id = id;
        this.properties = properties;
        this.webClient = webClient;
    }

    public String getNotifierId() {
        return this.id;
    }

    @Nonnull
    public NotifyType getType() {
        return DefaultNotifyType.webhook;
    }

    @Nonnull
    public Provider getProvider() {
        return WebHookProvider.http;
    }

    @Nonnull
    public Mono<Void> send(@Nonnull HttpWebHookTemplate template, @Nonnull Values context) {
        String body;
        HttpMethod method = template.getMethod();
        WebClient.RequestBodyUriSpec bodyUriSpec = this.webClient.method(template.getMethod());
        if (StringUtils.hasText((String)template.getUrl())) {
            bodyUriSpec.uri(template.getUrl(), new Object[0]);
        }
        if ((method == HttpMethod.POST || method == HttpMethod.PUT || method == HttpMethod.PATCH) && null != (body = template.resolveBody(context))) {
            bodyUriSpec.bodyValue((Object)body);
        }
        bodyUriSpec.headers(headers -> {
            if (CollectionUtils.isNotEmpty(this.properties.getHeaders())) {
                for (HttpWebHookProperties.Header header : this.properties.getHeaders()) {
                    headers.add(header.getKey(), header.getValue());
                }
            }
            if (CollectionUtils.isNotEmpty(template.getHeaders())) {
                for (HttpWebHookProperties.Header header : template.getHeaders()) {
                    headers.add(header.getKey(), header.getValue());
                }
            }
        });
        return bodyUriSpec.retrieve().bodyToMono(Void.class);
    }

    @Nonnull
    public Mono<Void> close() {
        return Mono.empty();
    }
}

