/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.notify.sms.aliyun;

import javax.annotation.Nonnull;
import org.hswebframework.web.i18n.LocaleUtils;
import org.jetlinks.community.notify.DefaultNotifyType;
import org.jetlinks.community.notify.NotifierProperties;
import org.jetlinks.community.notify.NotifierProvider;
import org.jetlinks.community.notify.NotifyType;
import org.jetlinks.community.notify.Provider;
import org.jetlinks.community.notify.sms.SmsProvider;
import org.jetlinks.community.notify.sms.aliyun.AliyunSmsNotifier;
import org.jetlinks.community.notify.sms.aliyun.AliyunSmsTemplate;
import org.jetlinks.community.notify.template.TemplateManager;
import org.jetlinks.community.notify.template.TemplateProperties;
import org.jetlinks.community.notify.template.TemplateProvider;
import org.jetlinks.core.metadata.ConfigMetadata;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.DefaultConfigMetadata;
import org.jetlinks.core.metadata.types.StringType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
public class AliyunSmsNotifierProvider
implements NotifierProvider,
TemplateProvider {
    private static final Logger log = LoggerFactory.getLogger(AliyunSmsNotifierProvider.class);
    private final TemplateManager templateManager;
    public static final DefaultConfigMetadata templateConfig = new DefaultConfigMetadata("\u963f\u91cc\u4e91\u77ed\u4fe1\u6a21\u7248", "https://help.aliyun.com/document_detail/108086.html").add("signName", "\u7b7e\u540d", "", (DataType)new StringType()).add("code", "\u6a21\u7248\u7f16\u7801", "", (DataType)new StringType()).add("phoneNumber", "\u6536\u4fe1\u4eba", "", (DataType)new StringType());
    public static final DefaultConfigMetadata notifierConfig = new DefaultConfigMetadata("\u963f\u91cc\u4e91API\u914d\u7f6e", "https://help.aliyun.com/document_detail/101300.html").add("regionId", "regionId", "regionId", (DataType)new StringType()).add("accessKeyId", "accessKeyId", "", (DataType)new StringType()).add("secret", "secret", "", (DataType)new StringType());

    @Nonnull
    public Provider getProvider() {
        return SmsProvider.aliyunSms;
    }

    public ConfigMetadata getTemplateConfigMetadata() {
        return templateConfig;
    }

    public ConfigMetadata getNotifierConfigMetadata() {
        return notifierConfig;
    }

    public Mono<AliyunSmsTemplate> createTemplate(TemplateProperties properties) {
        return (Mono)Mono.fromCallable(() -> (AliyunSmsTemplate)((AliyunSmsTemplate)new AliyunSmsTemplate().with(properties)).validate()).as(LocaleUtils::transform);
    }

    @Nonnull
    public NotifyType getType() {
        return DefaultNotifyType.sms;
    }

    @Nonnull
    public Mono<AliyunSmsNotifier> createNotifier(@Nonnull NotifierProperties properties) {
        return (Mono)Mono.fromSupplier(() -> new AliyunSmsNotifier(properties, this.templateManager)).as(LocaleUtils::transform);
    }

    public AliyunSmsNotifierProvider(TemplateManager templateManager) {
        this.templateManager = templateManager;
    }
}

