/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.io.excel.easyexcel;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.context.AnalysisContext;
import com.alibaba.excel.event.AnalysisEventListener;
import java.io.InputStream;
import org.jetlinks.community.io.excel.RowResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;

public class ExcelReadDataListener<T>
extends AnalysisEventListener<T> {
    private static final Logger log = LoggerFactory.getLogger(ExcelReadDataListener.class);
    private FluxSink<RowResult<T>> sink;

    public ExcelReadDataListener(FluxSink<RowResult<T>> sink) {
        this.sink = sink;
    }

    public static <T> Flux<RowResult<T>> of(InputStream fileInputStream, Class<T> clazz) {
        return Flux.create(sink -> EasyExcel.read((InputStream)fileInputStream, (Class)clazz, new ExcelReadDataListener(sink)).sheet().doRead());
    }

    public void onException(Exception exception, AnalysisContext context) {
        this.sink.error((Throwable)exception);
    }

    public void invoke(T data, AnalysisContext analysisContext) {
        RowResult<T> result = new RowResult<T>();
        result.setResult(data);
        result.setRowIndex(analysisContext.readRowHolder().getRowIndex());
        this.sink.next(result);
    }

    public void doAfterAllAnalysed(AnalysisContext analysisContext) {
        this.sink.complete();
    }

    public boolean hasNext(AnalysisContext context) {
        return !this.sink.isCancelled();
    }
}

