/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.gateway.supports;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.jetlinks.community.gateway.DeviceGateway;
import org.jetlinks.community.gateway.DeviceGatewayManager;
import org.jetlinks.community.gateway.supports.DeviceGatewayProperties;
import org.jetlinks.community.gateway.supports.DeviceGatewayPropertiesManager;
import org.jetlinks.community.gateway.supports.DeviceGatewayProvider;
import org.jetlinks.community.gateway.supports.DeviceGatewayProviders;
import org.jetlinks.community.network.channel.ChannelInfo;
import org.jetlinks.community.network.channel.ChannelProvider;
import org.jetlinks.core.cache.ReactiveCacheContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Mono;

public class DefaultDeviceGatewayManager
implements DeviceGatewayManager {
    private static final Logger log = LoggerFactory.getLogger(DefaultDeviceGatewayManager.class);
    private final DeviceGatewayPropertiesManager propertiesManager;
    private final Map<String, DeviceGatewayProvider> providers = new ConcurrentHashMap<String, DeviceGatewayProvider>();
    private final ReactiveCacheContainer<String, DeviceGateway> store = ReactiveCacheContainer.create();
    private final Map<String, ChannelProvider> channels = new ConcurrentHashMap<String, ChannelProvider>();

    public void addChannelProvider(ChannelProvider provider) {
        this.channels.put(provider.getChannel(), provider);
    }

    public void addGatewayProvider(DeviceGatewayProvider provider) {
        this.providers.put(provider.getId(), provider);
    }

    public DefaultDeviceGatewayManager(DeviceGatewayPropertiesManager propertiesManager) {
        this.propertiesManager = propertiesManager;
    }

    private Mono<DeviceGateway> doGetGateway(String id) {
        if (null == id) {
            return Mono.empty();
        }
        return this.store.computeIfAbsent((Object)id, this::createGateway);
    }

    protected Mono<DeviceGateway> createGateway(String id) {
        return this.propertiesManager.getProperties(id).switchIfEmpty(Mono.error(() -> new UnsupportedOperationException("\u7f51\u5173\u914d\u7f6e[" + id + "]\u4e0d\u5b58\u5728"))).flatMap(properties -> this.getProviderNow(properties.getProvider()).createDeviceGateway((DeviceGatewayProperties)properties));
    }

    public Mono<Void> doShutdown(String gatewayId) {
        return Mono.justOrEmpty((Object)this.store.remove((Object)gatewayId)).flatMap(DeviceGateway::shutdown).doOnSuccess(nil -> log.debug("shutdown device gateway {}", (Object)gatewayId)).doOnError(err -> log.error("shutdown device gateway {} error", (Object)gatewayId, err));
    }

    @Override
    public Mono<Void> shutdown(String gatewayId) {
        return this.doShutdown(gatewayId);
    }

    public Mono<Void> doStart(String id) {
        return this.getGateway(id).flatMap(DeviceGateway::startup).doOnSuccess(nil -> log.debug("started device gateway {}", (Object)id)).doOnError(err -> log.error("start device gateway {} error", (Object)id, err));
    }

    @Override
    public Mono<Void> start(String gatewayId) {
        return this.doStart(gatewayId);
    }

    @Override
    public Mono<DeviceGateway> getGateway(String id) {
        return this.doGetGateway(id);
    }

    @Override
    public Mono<Void> reload(String gatewayId) {
        return this.doReload(gatewayId);
    }

    private Mono<Void> doReload(String gatewayId) {
        return this.propertiesManager.getProperties(gatewayId).flatMap(prop -> {
            DeviceGatewayProvider provider = this.getProviderNow(prop.getProvider());
            return this.store.compute((Object)gatewayId, (id, gateway) -> {
                if (gateway != null) {
                    log.debug("reload device gateway {} {}:{}", new Object[]{prop.getName(), prop.getProvider(), prop.getId()});
                    return provider.reloadDeviceGateway((DeviceGateway)gateway, (DeviceGatewayProperties)prop).cast(DeviceGateway.class);
                }
                log.debug("create device gateway {} {}:{}", new Object[]{prop.getName(), prop.getProvider(), prop.getId()});
                return provider.createDeviceGateway((DeviceGatewayProperties)prop).flatMap(newer -> newer.startup().thenReturn(newer));
            });
        }).then();
    }

    @Override
    public List<DeviceGatewayProvider> getProviders() {
        return this.providers.values().stream().sorted(Comparator.comparingInt(DeviceGatewayProvider::getOrder)).collect(Collectors.toList());
    }

    @Override
    public Optional<DeviceGatewayProvider> getProvider(String provider) {
        return Optional.ofNullable(this.providers.get(provider));
    }

    public DeviceGatewayProvider getProviderNow(String provider) {
        return DeviceGatewayProviders.getProviderNow(provider);
    }

    @Override
    public Mono<ChannelInfo> getChannel(String channel, String channelId) {
        if (!StringUtils.hasText((String)channel) || !StringUtils.hasText((String)channel)) {
            return Mono.empty();
        }
        return Mono.justOrEmpty((Object)this.channels.get(channel)).flatMap(provider -> provider.getChannelInfo(channelId));
    }
}

