/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.gateway.spring;

import java.lang.reflect.Method;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import org.hswebframework.web.bean.FastBeanCopier;
import org.hswebframework.web.proxy.Proxy;
import org.jetlinks.community.gateway.spring.MessageListener;
import org.jetlinks.core.NativePayload;
import org.jetlinks.core.Payload;
import org.jetlinks.core.codec.Codecs;
import org.jetlinks.core.codec.Decoder;
import org.jetlinks.core.event.TopicPayload;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ResolvableType;
import org.springframework.util.ClassUtils;
import reactor.core.publisher.Mono;

class ProxyMessageListener
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger(ProxyMessageListener.class);
    private final Class<?> paramType;
    private final Object target;
    private final ResolvableType resolvableType;
    private final Method method;
    private final BiFunction<Object, Object, Object> proxy;
    private volatile Decoder<?> decoder;

    ProxyMessageListener(Object target, Method method) {
        String invokeCode;
        this.target = target;
        this.method = method;
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length > 1) {
            throw new UnsupportedOperationException("unsupported method [" + method + "] parameter");
        }
        this.paramType = parameterTypes.length == 1 ? parameterTypes[0] : Void.class;
        Class targetType = ClassUtils.getUserClass((Object)target);
        StringJoiner code = new StringJoiner("\n");
        code.add("public Object apply(Object target,Object param){");
        code.add(targetType.getName() + " _target = (" + targetType.getName() + ")target;");
        if (this.paramType != Void.class) {
            code.add(this.paramType.getName() + " _param = (" + this.paramType.getName() + ")param;");
            invokeCode = " _target." + method.getName() + "(_param);";
        } else {
            invokeCode = " _target." + method.getName() + "();";
        }
        if (method.getReturnType() != Void.TYPE) {
            code.add("return " + invokeCode);
        } else {
            code.add(invokeCode).add("return null;");
        }
        code.add("}");
        this.resolvableType = ResolvableType.forMethodParameter((Method)method, (int)0, (Class)targetType);
        this.proxy = (BiFunction)Proxy.create(BiFunction.class, (String[])new String[0]).addMethod(code.toString()).newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Object convert(TopicPayload message) {
        if (Payload.class.isAssignableFrom(this.paramType)) {
            return message;
        }
        try {
            Object decodedPayload;
            Payload payload = message.getPayload();
            if (payload instanceof NativePayload) {
                decodedPayload = ((NativePayload)payload).getNativeObject();
            } else {
                if (this.decoder == null) {
                    this.decoder = Codecs.lookup((ResolvableType)this.resolvableType);
                }
                decodedPayload = this.decoder.decode((Payload)message);
            }
            if (this.paramType.isInstance(decodedPayload)) {
                Object object = decodedPayload;
                return object;
            }
            Object object = FastBeanCopier.DEFAULT_CONVERT.convert(decodedPayload, this.paramType, this.resolvableType.resolveGenerics());
            return object;
        }
        finally {
            message.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Mono<Void> onMessage(TopicPayload message) {
        try {
            boolean paramVoid = this.paramType == Void.class;
            try {
                Object val = this.proxy.apply(this.target, paramVoid ? null : this.convert(message));
                if (val instanceof Publisher) {
                    Mono mono2 = Mono.from((Publisher)((Publisher)val)).then();
                    return mono2;
                }
                Mono mono = Mono.empty();
                return mono;
            }
            finally {
                if (paramVoid) {
                    message.release();
                }
            }
        }
        catch (Throwable e) {
            log.error("invoke event listener [{}] error", (Object)this.toString(), (Object)e);
            return Mono.empty();
        }
    }

    public String toString() {
        return ClassUtils.getUserClass((Object)this.target).getSimpleName() + "." + this.method.getName();
    }
}

