/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.gateway.external.dashboard;

import java.util.Map;
import org.jetlinks.community.dashboard.DashboardManager;
import org.jetlinks.community.dashboard.MeasurementParameter;
import org.jetlinks.community.gateway.external.Message;
import org.jetlinks.community.gateway.external.SubscribeRequest;
import org.jetlinks.community.gateway.external.SubscriptionProvider;
import org.jetlinks.core.utils.TopicUtils;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Flux;

@Component
public class DashBoardSubscriptionProvider
implements SubscriptionProvider {
    private final DashboardManager dashboardManager;

    public DashBoardSubscriptionProvider(DashboardManager dashboardManager) {
        this.dashboardManager = dashboardManager;
    }

    @Override
    public String id() {
        return "dashboard";
    }

    @Override
    public String name() {
        return "\u4eea\u8868\u76d8";
    }

    @Override
    public String[] getTopicPattern() {
        return new String[]{"/dashboard/**"};
    }

    public Flux<Message> subscribe(SubscribeRequest request) {
        return Flux.defer(() -> {
            try {
                Map variables = TopicUtils.getPathVariables((String)"/dashboard/{dashboard}/{object}/{measurement}/{dimension}", (String)request.getTopic());
                return this.dashboardManager.getDashboard((String)variables.get("dashboard")).flatMap(dashboard -> dashboard.getObject((String)variables.get("object"))).flatMap(object -> object.getMeasurement((String)variables.get("measurement"))).flatMap(measurement -> measurement.getDimension((String)variables.get("dimension"))).flatMapMany(dimension -> dimension.getValue(MeasurementParameter.of(request.getParameter()))).map(val -> Message.success(request.getId(), request.getTopic(), val));
            }
            catch (Exception e) {
                return Flux.error((Throwable)new IllegalArgumentException("topic\u683c\u5f0f\u9519\u8bef,\u6b63\u786e\u683c\u5f0f:/dashboard/{dashboard}/{object}/{measurement}/{dimension}", e));
            }
        });
    }
}

