/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.gateway;

import org.jetlinks.community.gateway.DeviceGatewayManager;
import org.jetlinks.community.gateway.supports.ChildDeviceGatewayProvider;
import org.jetlinks.community.gateway.supports.DefaultDeviceGatewayManager;
import org.jetlinks.community.gateway.supports.DeviceGatewayPropertiesManager;
import org.jetlinks.community.gateway.supports.DeviceGatewayProvider;
import org.jetlinks.community.gateway.supports.DeviceGatewayProviders;
import org.jetlinks.community.network.channel.ChannelProvider;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;

@AutoConfiguration
@ConditionalOnClass(value={ChannelProvider.class})
public class GatewayConfiguration {
    @Bean
    @ConditionalOnBean(value={DeviceGatewayPropertiesManager.class})
    public DeviceGatewayManager deviceGatewayManager(ObjectProvider<ChannelProvider> channelProviders, ObjectProvider<DeviceGatewayProvider> gatewayProviders, DeviceGatewayPropertiesManager propertiesManager) {
        DefaultDeviceGatewayManager gatewayManager = new DefaultDeviceGatewayManager(propertiesManager);
        channelProviders.forEach(gatewayManager::addChannelProvider);
        gatewayProviders.forEach(gatewayManager::addGatewayProvider);
        gatewayProviders.forEach(DeviceGatewayProviders::register);
        return gatewayManager;
    }

    @Bean
    public ChildDeviceGatewayProvider childDeviceGatewayProvider() {
        return new ChildDeviceGatewayProvider();
    }
}

