/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.elastic.search.utils;

import java.util.function.Consumer;
import java.util.function.Function;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.action.ActionListener;
import org.hswebframework.web.exception.BusinessException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoSink;

public class ReactorActionListener {
    private static final Logger log = LoggerFactory.getLogger(ReactorActionListener.class);

    public static <R, T> Mono<R> mono(Consumer<ActionListener<T>> listenerConsumer, Function<T, Mono<R>> onSuccess, Function<Exception, Mono<R>> onError) {
        return Mono.create(sink -> listenerConsumer.accept(new ActionListener<T>((MonoSink)sink, onSuccess, onError){
            final /* synthetic */ MonoSink val$sink;
            final /* synthetic */ Function val$onSuccess;
            final /* synthetic */ Function val$onError;
            {
                this.val$sink = monoSink;
                this.val$onSuccess = function;
                this.val$onError = function2;
            }

            public void onResponse(T t) {
                try {
                    this.val$sink.success(this.val$onSuccess.apply(t));
                }
                catch (Exception e) {
                    this.val$sink.error((Throwable)e);
                }
            }

            public void onFailure(Exception e) {
                try {
                    this.val$sink.success(this.val$onError.apply(e));
                }
                catch (Exception e2) {
                    this.val$sink.error((Throwable)e2);
                }
            }
        })).flatMap(Function.identity()).onErrorResume(ElasticsearchStatusException.class, e -> {
            if (e.status().getStatus() == 404) {
                if (e.getMessage().contains("index_not_found_exception")) {
                    log.debug("{}", (Object)e.getMessage());
                } else {
                    log.warn("{}", (Object)e.getDetailedMessage(), e);
                }
                return Mono.empty();
            }
            return Mono.error((Throwable)new BusinessException(e.getMessage(), (Throwable)e));
        });
    }

    public static <R, T> Mono<R> mono(Consumer<ActionListener<T>> listenerConsumer, Function<T, Mono<R>> onSuccess) {
        return ReactorActionListener.mono(listenerConsumer, onSuccess, Mono::error);
    }

    public static <R> Mono<R> mono(Consumer<ActionListener<R>> listenerConsumer) {
        return ReactorActionListener.mono(listenerConsumer, Mono::justOrEmpty, Mono::error);
    }
}

