/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.elastic.search.enums;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Optional;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.hswebframework.ezorm.core.param.Term;
import org.jetlinks.community.elastic.search.enums.TermTypeEnum;

public enum LinkTypeEnum {
    and("and"){

        @Override
        public void process(BoolQueryBuilder query, Term term) {
            if (term.getTerms().isEmpty()) {
                query.must(TermTypeEnum.of(term.getTermType().trim()).map(e -> e.process(term)).orElse((QueryBuilder)QueryBuilders.boolQuery()));
            } else {
                BoolQueryBuilder nextQuery = QueryBuilders.boolQuery();
                LinkedList terms = (LinkedList)term.getTerms();
                LinkTypeEnum.of(LinkTypeEnum.getLast(terms).getType().name()).ifPresent(e -> terms.forEach(t -> e.process(nextQuery, (Term)t)));
                query.must((QueryBuilder)nextQuery);
            }
        }
    }
    ,
    or("or"){

        @Override
        public void process(BoolQueryBuilder query, Term term) {
            if (term.getTerms().isEmpty()) {
                query.should(TermTypeEnum.of(term.getTermType().trim()).map(e -> e.process(term)).orElse((QueryBuilder)QueryBuilders.boolQuery()));
            } else {
                BoolQueryBuilder nextQuery = QueryBuilders.boolQuery();
                LinkedList terms = (LinkedList)term.getTerms();
                LinkTypeEnum.of(LinkTypeEnum.getLast(terms).getType().name()).ifPresent(e -> terms.forEach(t -> e.process(nextQuery, (Term)t)));
                query.should((QueryBuilder)nextQuery);
            }
        }
    };

    private final String type;

    public abstract void process(BoolQueryBuilder var1, Term var2);

    public static Optional<LinkTypeEnum> of(String type) {
        return Arrays.stream(LinkTypeEnum.values()).filter(e -> e.getType().equalsIgnoreCase(type)).findAny();
    }

    private static Term getLast(LinkedList<Term> terms) {
        int index;
        for (index = terms.indexOf(terms.getLast()); index >= 0 && !terms.get(index).getTerms().isEmpty(); --index) {
        }
        return terms.get(index);
    }

    public String getType() {
        return this.type;
    }

    private LinkTypeEnum(String type) {
        this.type = type;
    }
}

