/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.elastic.search.aggreation.enums;

import java.util.Collections;
import java.util.HashMap;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.metrics.Avg;
import org.elasticsearch.search.aggregations.metrics.Max;
import org.elasticsearch.search.aggregations.metrics.Min;
import org.elasticsearch.search.aggregations.metrics.Stats;
import org.elasticsearch.search.aggregations.metrics.Sum;
import org.elasticsearch.search.aggregations.metrics.ValueCount;
import org.jetlinks.community.elastic.search.aggreation.metrics.MetricsResponse;
import org.jetlinks.community.elastic.search.aggreation.metrics.MetricsResponseSingleValue;

public enum MetricsType {
    AVG("\u5e73\u5747"){

        @Override
        public AggregationBuilder aggregationBuilder(String name, String filed) {
            return AggregationBuilders.avg((String)name).field(filed);
        }

        @Override
        public MetricsResponse getResponse(String name, SearchResponse response) {
            Avg avg = (Avg)response.getAggregations().get(name);
            return MetricsResponse.builder().results(Collections.singletonMap(AVG, new MetricsResponseSingleValue(avg.getValue(), avg.getName(), avg.getValueAsString()))).build();
        }
    }
    ,
    MAX("\u6700\u5927"){

        @Override
        public AggregationBuilder aggregationBuilder(String name, String filed) {
            return AggregationBuilders.max((String)name).field(filed);
        }

        @Override
        public MetricsResponse getResponse(String name, SearchResponse response) {
            Max max = (Max)response.getAggregations().get(name);
            return MetricsResponse.builder().results(Collections.singletonMap(MAX, new MetricsResponseSingleValue(max.getValue(), max.getName(), max.getValueAsString()))).build();
        }
    }
    ,
    COUNT("\u975e\u7a7a\u503c\u8ba1\u6570"){

        @Override
        public AggregationBuilder aggregationBuilder(String name, String filed) {
            return AggregationBuilders.count((String)name).field(filed);
        }

        @Override
        public MetricsResponse getResponse(String name, SearchResponse response) {
            ValueCount valueCount = (ValueCount)response.getAggregations().get(name);
            return MetricsResponse.builder().results(Collections.singletonMap(COUNT, new MetricsResponseSingleValue(valueCount.getValue(), valueCount.getName(), valueCount.getValueAsString()))).build();
        }
    }
    ,
    MIN("\u6700\u5c0f"){

        @Override
        public AggregationBuilder aggregationBuilder(String name, String filed) {
            return AggregationBuilders.min((String)name).field(filed);
        }

        @Override
        public MetricsResponse getResponse(String name, SearchResponse response) {
            Min min = (Min)response.getAggregations().get(name);
            return MetricsResponse.builder().results(Collections.singletonMap(MIN, new MetricsResponseSingleValue(min.getValue(), min.getName(), min.getValueAsString()))).build();
        }
    }
    ,
    SUM("\u603b\u6570"){

        @Override
        public AggregationBuilder aggregationBuilder(String name, String filed) {
            return AggregationBuilders.sum((String)name).field(filed);
        }

        @Override
        public MetricsResponse getResponse(String name, SearchResponse response) {
            Sum sum = (Sum)response.getAggregations().get(name);
            return MetricsResponse.builder().results(Collections.singletonMap(SUM, new MetricsResponseSingleValue(sum.getValue(), sum.getName(), sum.getValueAsString()))).build();
        }
    }
    ,
    STATS("\u7edf\u8ba1\u6c47\u603b"){

        @Override
        public AggregationBuilder aggregationBuilder(String name, String filed) {
            return AggregationBuilders.stats((String)name).field(filed);
        }

        @Override
        public MetricsResponse getResponse(String name, SearchResponse response) {
            Stats stats = (Stats)response.getAggregations().get(name);
            HashMap<MetricsType, MetricsResponseSingleValue> results = new HashMap<MetricsType, MetricsResponseSingleValue>();
            results.put(AVG, new MetricsResponseSingleValue(stats.getAvg(), stats.getName(), stats.getAvgAsString()));
            results.put(MIN, new MetricsResponseSingleValue(stats.getMin(), stats.getName(), stats.getMinAsString()));
            results.put(MAX, new MetricsResponseSingleValue(stats.getMax(), stats.getName(), stats.getMaxAsString()));
            results.put(SUM, new MetricsResponseSingleValue(stats.getSum(), stats.getName(), stats.getMaxAsString()));
            results.put(COUNT, new MetricsResponseSingleValue(stats.getCount(), stats.getName(), String.valueOf(stats.getCount())));
            return MetricsResponse.builder().results(results).build();
        }
    };

    private String text;

    public abstract AggregationBuilder aggregationBuilder(String var1, String var2);

    public abstract MetricsResponse getResponse(String var1, SearchResponse var2);

    public static MetricsType of(String name) {
        for (MetricsType type : MetricsType.values()) {
            if (!type.name().equalsIgnoreCase(name)) continue;
            return type;
        }
        throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u805a\u5408\u5ea6\u91cf\u7c7b\u578b\uff1a" + name);
    }

    public String getText() {
        return this.text;
    }

    private MetricsType(String text) {
        this.text = text;
    }
}

