/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.elastic.search.index.mapping;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetlinks.community.elastic.search.enums.ElasticPropertyType;
import org.jetlinks.community.elastic.search.index.mapping.SingleMappingMetadata;

public class IndexMappingMetadata {
    private String index;
    private Map<String, SingleMappingMetadata> metadata = new HashMap<String, SingleMappingMetadata>();

    public List<SingleMappingMetadata> getAllMetaData() {
        return this.metadata.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }

    public SingleMappingMetadata getMetaData(String fieldName) {
        return this.metadata.get(fieldName);
    }

    public List<SingleMappingMetadata> getMetaDataByType(ElasticPropertyType type) {
        return this.getAllMetaData().stream().filter(singleMapping -> singleMapping.getType().equals((Object)type)).collect(Collectors.toList());
    }

    public Map<String, SingleMappingMetadata> getMetaDataByTypeToMap(ElasticPropertyType type) {
        return this.getMetaDataByType(type).stream().collect(Collectors.toMap(SingleMappingMetadata::getName, Function.identity()));
    }

    public void setMetadata(SingleMappingMetadata singleMapping) {
        this.metadata.put(singleMapping.getName(), singleMapping);
    }

    private IndexMappingMetadata(String index) {
        this.index = index;
    }

    private IndexMappingMetadata() {
    }

    public static IndexMappingMetadata getInstance(String index) {
        return new IndexMappingMetadata(index);
    }

    public String getIndex() {
        return this.index;
    }

    public Map<String, SingleMappingMetadata> getMetadata() {
        return this.metadata;
    }

    public void setIndex(String index) {
        this.index = index;
    }
}

