/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.elastic.search.aggreation.bucket;

import java.util.List;
import java.util.stream.Collectors;
import org.elasticsearch.search.aggregations.Aggregation;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;
import org.elasticsearch.search.aggregations.bucket.range.Range;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.metrics.Avg;
import org.elasticsearch.search.aggregations.metrics.Max;
import org.elasticsearch.search.aggregations.metrics.Min;
import org.elasticsearch.search.aggregations.metrics.Stats;
import org.elasticsearch.search.aggregations.metrics.Sum;
import org.elasticsearch.search.aggregations.metrics.ValueCount;
import org.jetlinks.community.elastic.search.aggreation.bucket.Bucket;
import org.jetlinks.community.elastic.search.aggreation.metrics.MetricsResponseSingleValue;

public class AggregationResponseHandle {
    public static <A extends Aggregation> List<Bucket> terms(A a) {
        Terms terms = (Terms)a;
        return terms.getBuckets().stream().map(b -> {
            Bucket bucket = Bucket.builder().key(b.getKeyAsString()).count(b.getDocCount()).name(a.getName()).build();
            b.getAggregations().asList().forEach(subAggregation -> AggregationResponseHandle.route(bucket, subAggregation));
            return bucket;
        }).collect(Collectors.toList());
    }

    public static <A extends Aggregation> List<Bucket> range(A a) {
        Range range = (Range)a;
        return range.getBuckets().stream().map(b -> {
            Bucket bucket = Bucket.builder().key(b.getKeyAsString()).from(b.getFrom()).to(b.getTo()).fromAsString(b.getFromAsString()).toAsString(b.getToAsString()).count(b.getDocCount()).build();
            b.getAggregations().asList().forEach(subAggregation -> AggregationResponseHandle.route(bucket, subAggregation));
            return bucket;
        }).collect(Collectors.toList());
    }

    public static <A extends Aggregation> List<Bucket> dateHistogram(A a) {
        Histogram histogram = (Histogram)a;
        return AggregationResponseHandle.bucketsHandle(histogram.getBuckets(), a.getName());
    }

    private static List<Bucket> bucketsHandle(List<? extends Histogram.Bucket> buckets, String name) {
        return buckets.stream().map(b -> {
            Bucket bucket = Bucket.builder().key(b.getKeyAsString()).count(b.getDocCount()).name(name).build();
            b.getAggregations().asList().forEach(subAggregation -> AggregationResponseHandle.route(bucket, subAggregation));
            return bucket;
        }).collect(Collectors.toList());
    }

    private static <A extends Aggregation> void route(Bucket bucket, A a) {
        if (a instanceof Terms) {
            bucket.setBuckets(AggregationResponseHandle.terms(a));
        } else if (a instanceof Range) {
            bucket.setBuckets(AggregationResponseHandle.range(a));
        } else if (a instanceof Histogram) {
            bucket.setBuckets(AggregationResponseHandle.range(a));
        } else if (a instanceof Avg) {
            bucket.setAvg(AggregationResponseHandle.avg(a));
        } else if (a instanceof Min) {
            bucket.setMin(AggregationResponseHandle.min(a));
        } else if (a instanceof Max) {
            bucket.setMax(AggregationResponseHandle.max(a));
        } else if (a instanceof Sum) {
            bucket.setSum(AggregationResponseHandle.sum(a));
        } else if (a instanceof Stats) {
            AggregationResponseHandle.stats(bucket, a);
        } else if (a instanceof ValueCount) {
            bucket.setValueCount(AggregationResponseHandle.count(a));
        } else {
            throw new UnsupportedOperationException("\u4e0d\u652f\u6301\u7684\u805a\u5408\u7c7b\u578b");
        }
    }

    public static <A extends Aggregation> MetricsResponseSingleValue count(A a) {
        ValueCount max = (ValueCount)a;
        return MetricsResponseSingleValue.builder().value(max.getValue()).name(a.getName()).valueAsString(max.getValueAsString()).build();
    }

    public static <A extends Aggregation> MetricsResponseSingleValue avg(A a) {
        Avg avg = (Avg)a;
        return MetricsResponseSingleValue.builder().value(avg.getValue()).name(a.getName()).valueAsString(avg.getValueAsString()).build();
    }

    public static <A extends Aggregation> MetricsResponseSingleValue max(A a) {
        Max max = (Max)a;
        return MetricsResponseSingleValue.builder().value(max.getValue()).name(a.getName()).valueAsString(max.getValueAsString()).build();
    }

    public static <A extends Aggregation> MetricsResponseSingleValue min(A a) {
        Min min = (Min)a;
        return MetricsResponseSingleValue.builder().value(min.getValue()).name(a.getName()).valueAsString(min.getValueAsString()).build();
    }

    public static <A extends Aggregation> MetricsResponseSingleValue sum(A a) {
        Sum sum = (Sum)a;
        return MetricsResponseSingleValue.builder().value(sum.getValue()).name(a.getName()).valueAsString(sum.getValueAsString()).build();
    }

    public static <A extends Aggregation> void stats(Bucket bucket, A a) {
        Stats stats = (Stats)a;
        bucket.setAvg(MetricsResponseSingleValue.builder().value(stats.getAvg()).name(a.getName()).valueAsString(stats.getAvgAsString()).build());
        bucket.setMax(MetricsResponseSingleValue.builder().value(stats.getMax()).name(a.getName()).valueAsString(stats.getMaxAsString()).build());
        bucket.setMin(MetricsResponseSingleValue.builder().value(stats.getMin()).name(a.getName()).valueAsString(stats.getMinAsString()).build());
        bucket.setSum(MetricsResponseSingleValue.builder().value(stats.getSum()).name(a.getName()).valueAsString(stats.getSumAsString()).build());
    }
}

