/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.dashboard.measurements;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.function.Function;
import oshi.SystemInfo;
import oshi.hardware.GlobalMemory;

public enum SystemMonitor {
    systemCpuUsage("\u7cfb\u7edfCPU\u4f7f\u7528\u7387"),
    jvmCpuUsage("JVM\u8fdb\u7a0bCPU\u4f7f\u7528\u7387"),
    freeSystemMemory("\u7cfb\u7edf\u7a7a\u95f2\u5185\u5b58"),
    totalSystemMemory("\u7cfb\u7edf\u603b\u5185\u5b58"),
    openFileCount("\u5df2\u6253\u5f00\u6587\u4ef6\u6570"),
    maxOpenFileCount("\u6700\u5927\u6253\u5f00\u6587\u4ef6\u6570");

    private final String text;
    static final OperatingSystemMXBean osMxBean;
    private static final Map<String, Callable<Double>> items;
    private static final List<String> OPERATING_SYSTEM_BEAN_CLASS_NAMES;
    private static final Callable<Double> zero;
    private static Class<?> mxBeanClass;

    public double getValue() {
        return SystemMonitor.getValue(this.name());
    }

    private static void register(String item, String methodName, Function<Double, Double> mapping) {
        try {
            Method method = mxBeanClass.getMethod(methodName, new Class[0]);
            items.put(item, () -> (Double)mapping.apply(((Number)method.invoke((Object)osMxBean, new Object[0])).doubleValue()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public double value() {
        return SystemMonitor.getValue(this.name());
    }

    public static double getValue(String id) {
        double val = items.getOrDefault(id, zero).call();
        return Double.isNaN(val) ? 0.0 : val;
    }

    private SystemMonitor(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    static {
        osMxBean = ManagementFactory.getOperatingSystemMXBean();
        items = new HashMap<String, Callable<Double>>();
        OPERATING_SYSTEM_BEAN_CLASS_NAMES = Arrays.asList("com.sun.management.OperatingSystemMXBean", "com.ibm.lang.management.OperatingSystemMXBean");
        zero = () -> 0.0;
        for (String s : OPERATING_SYSTEM_BEAN_CLASS_NAMES) {
            try {
                mxBeanClass = Class.forName(s);
            }
            catch (Exception exception) {}
        }
        GlobalMemory memory = new SystemInfo().getHardware().getMemory();
        items.put(freeSystemMemory.name(), () -> (double)(memory.getAvailable() / 1024L) / 1024.0);
        items.put(totalSystemMemory.name(), () -> (double)(memory.getTotal() / 1024L) / 1024.0);
        try {
            if (mxBeanClass != null) {
                SystemMonitor.register(systemCpuUsage.name(), "getSystemCpuLoad", usage -> usage * 100.0);
                SystemMonitor.register(jvmCpuUsage.name(), "getProcessCpuLoad", usage -> usage * 100.0);
                SystemMonitor.register("virtualMemory", "getCommittedVirtualMemorySize", val -> val / 1024.0 / 1024.0);
                SystemMonitor.register(openFileCount.name(), "getOpenFileDescriptorCount", Function.identity());
                SystemMonitor.register(maxOpenFileCount.name(), "getMaxFileDescriptorCount", Function.identity());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

