/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.utils;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.jetlinks.core.message.MessageType;

public class MessageTypeMatcher {
    private Set<String> excludes;
    private Set<String> includes = new HashSet<String>(Collections.singleton("*"));
    private boolean excludeFirst = true;
    private long excludesMask;
    private long includesMask;

    public void setExcludes(Set<String> excludes) {
        this.excludes = excludes;
        this.init();
    }

    public void setIncludes(Set<String> includes) {
        this.includes = includes;
        this.init();
    }

    private long createMask(Collection<MessageType> messageTypes) {
        long mask = 0L;
        for (MessageType messageType : messageTypes) {
            mask |= 1L << messageType.ordinal();
        }
        return mask;
    }

    protected void init() {
        if (!CollectionUtils.isEmpty(this.excludes)) {
            this.excludesMask = this.excludes.contains("*") ? this.createMask(Arrays.asList(MessageType.values())) : this.createMask(this.excludes.stream().map(String::toUpperCase).map(MessageType::valueOf).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty(this.includes)) {
            this.includesMask = this.includes.contains("*") ? this.createMask(Arrays.asList(MessageType.values())) : this.createMask(this.includes.stream().map(String::toUpperCase).map(MessageType::valueOf).collect(Collectors.toList()));
        }
    }

    public boolean match(MessageType type) {
        long mask = 1L << type.ordinal();
        if (this.includesMask != 0L) {
            boolean include;
            boolean bl = include = (this.includesMask & mask) != 0L;
            if (this.excludeFirst && this.excludesMask != 0L) {
                return include && (this.excludesMask & mask) == 0L;
            }
            return include;
        }
        if (this.excludesMask != 0L) {
            return (this.excludesMask & mask) == 0L;
        }
        return true;
    }

    public static MessageTypeMatcherBuilder builder() {
        return new MessageTypeMatcherBuilder();
    }

    public MessageTypeMatcher(Set<String> excludes, Set<String> includes, boolean excludeFirst, long excludesMask, long includesMask) {
        this.excludes = excludes;
        this.includes = includes;
        this.excludeFirst = excludeFirst;
        this.excludesMask = excludesMask;
        this.includesMask = includesMask;
    }

    public MessageTypeMatcher() {
    }

    public Set<String> getExcludes() {
        return this.excludes;
    }

    public Set<String> getIncludes() {
        return this.includes;
    }

    public void setExcludeFirst(boolean excludeFirst) {
        this.excludeFirst = excludeFirst;
    }

    public boolean isExcludeFirst() {
        return this.excludeFirst;
    }

    public static class MessageTypeMatcherBuilder {
        private Set<String> excludes;
        private Set<String> includes;
        private boolean excludeFirst;
        private long excludesMask;
        private long includesMask;

        MessageTypeMatcherBuilder() {
        }

        public MessageTypeMatcherBuilder excludes(Set<String> excludes) {
            this.excludes = excludes;
            return this;
        }

        public MessageTypeMatcherBuilder includes(Set<String> includes) {
            this.includes = includes;
            return this;
        }

        public MessageTypeMatcherBuilder excludeFirst(boolean excludeFirst) {
            this.excludeFirst = excludeFirst;
            return this;
        }

        public MessageTypeMatcherBuilder excludesMask(long excludesMask) {
            this.excludesMask = excludesMask;
            return this;
        }

        public MessageTypeMatcherBuilder includesMask(long includesMask) {
            this.includesMask = includesMask;
            return this;
        }

        public MessageTypeMatcher build() {
            return new MessageTypeMatcher(this.excludes, this.includes, this.excludeFirst, this.excludesMask, this.includesMask);
        }

        public String toString() {
            return "MessageTypeMatcher.MessageTypeMatcherBuilder(excludes=" + this.excludes + ", includes=" + this.includes + ", excludeFirst=" + this.excludeFirst + ", excludesMask=" + this.excludesMask + ", includesMask=" + this.includesMask + ")";
        }
    }
}

