/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.reactorql.term;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.hswebframework.ezorm.core.param.Term;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.NativeSql;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.PrepareSqlFragments;
import org.hswebframework.ezorm.rdb.operator.builder.fragments.SqlFragments;
import org.hswebframework.web.i18n.LocaleUtils;
import org.jetlinks.community.reactorql.term.TermTypeSupport;
import org.jetlinks.core.metadata.DataType;

public enum FixedTermTypeSupport implements TermTypeSupport
{
    eq("\u7b49\u4e8e", "eq", new String[0]),
    neq("\u4e0d\u7b49\u4e8e", "neq", new String[0]),
    gt("\u5927\u4e8e", "gt", "date", "int", "long", "float", "double"),
    gte("\u5927\u4e8e\u7b49\u4e8e", "gte", "date", "int", "long", "float", "double"),
    lt("\u5c0f\u4e8e", "lt", "date", "int", "long", "float", "double"),
    lte("\u5c0f\u4e8e\u7b49\u4e8e", "lte", "date", "int", "long", "float", "double"),
    btw("\u5728...\u4e4b\u95f4", "btw", new String[]{"date", "int", "long", "float", "double"}){

        @Override
        protected Object convertValue(Object val, Term term) {
            return val;
        }
    }
    ,
    nbtw("\u4e0d\u5728...\u4e4b\u95f4", "nbtw", new String[]{"date", "int", "long", "float", "double"}){

        @Override
        protected Object convertValue(Object val, Term term) {
            return val;
        }
    }
    ,
    in("\u5728...\u4e4b\u4e2d", "in", new String[]{"string", "int", "long", "float", "double", "enum"}){

        @Override
        protected Object convertValue(Object val, Term term) {
            return val;
        }
    }
    ,
    nin("\u4e0d\u5728...\u4e4b\u4e2d", "nin", new String[]{"string", "int", "long", "float", "double", "enum"}){

        @Override
        protected Object convertValue(Object val, Term term) {
            return val;
        }
    }
    ,
    contains_all("\u5168\u90e8\u5305\u542b\u5728...\u4e4b\u4e2d", "contains_all", new String[]{"array"}){

        @Override
        protected Object convertValue(Object val, Term term) {
            return val;
        }
    }
    ,
    contains_any("\u4efb\u610f\u5305\u542b\u5728...\u4e4b\u4e2d", "contains_any", new String[]{"array"}){

        @Override
        protected Object convertValue(Object val, Term term) {
            return val;
        }
    }
    ,
    not_contains("\u4e0d\u5305\u542b\u5728...\u4e4b\u4e2d", "not_contains", new String[]{"array"}){

        @Override
        protected Object convertValue(Object val, Term term) {
            return val;
        }
    }
    ,
    like("\u5305\u542b\u5b57\u7b26", "str_like", new String[]{"string"}){

        @Override
        protected Object convertValue(Object val, Term term) {
            if (val instanceof NativeSql) {
                NativeSql sql = (NativeSql)val;
                return NativeSql.of((String)("concat('%'," + sql.getSql() + ",'%')"), (Object[])new Object[0]);
            }
            return super.convertValue(val, term);
        }
    }
    ,
    nlike("\u4e0d\u5305\u542b\u5b57\u7b26", "str_nlike", new String[]{"string"}){

        @Override
        protected Object convertValue(Object val, Term term) {
            if (val instanceof NativeSql) {
                NativeSql sql = (NativeSql)val;
                return NativeSql.of((String)("concat('%'," + sql.getSql() + ",'%')"), (Object[])new Object[0]);
            }
            return super.convertValue(val, term);
        }
    }
    ,
    time_gt_now("\u8ddd\u79bb\u5f53\u524d\u65f6\u95f4\u5927\u4e8e...\u79d2", "time_gt_now", new String[]{"date"}){

        @Override
        protected void appendFunction(String column, PrepareSqlFragments fragments) {
            fragments.addSql(new String[]{"gt(math.divi(math.sub(now(),", column, "),1000),"});
        }
    }
    ,
    time_lt_now("\u8ddd\u79bb\u5f53\u524d\u65f6\u95f4\u5c0f\u4e8e...\u79d2", "time_lt_now", new String[]{"date"}){

        @Override
        protected void appendFunction(String column, PrepareSqlFragments fragments) {
            fragments.addSql(new String[]{"lt(math.divi(math.sub(now(),", column, "),1000),"});
        }
    };

    private final String text;
    private final Set<String> supportTypes;
    private final String function;

    private FixedTermTypeSupport(String text, String function, String ... supportTypes) {
        this.text = text;
        this.function = function;
        this.supportTypes = new HashSet<String>(Arrays.asList(supportTypes));
    }

    @Override
    public boolean isSupported(DataType type) {
        return this.supportTypes.isEmpty() || this.supportTypes.contains(type.getType());
    }

    protected Object convertValue(Object val, Term term) {
        if (val instanceof Collection && ((Collection)val).size() == 1) {
            return ((Collection)val).iterator().next();
        }
        return val;
    }

    protected void appendFunction(String column, PrepareSqlFragments fragments) {
        fragments.addSql(new String[]{this.function + "(", column, ","});
    }

    @Override
    public SqlFragments createSql(String column, Object value, Term term) {
        PrepareSqlFragments fragments = PrepareSqlFragments.of();
        this.appendFunction(column, fragments);
        if (term.getOptions().contains("native")) {
            value = NativeSql.of((String)String.valueOf(value), (Object[])new Object[0]);
        }
        if ((value = this.convertValue(value, term)) instanceof NativeSql) {
            fragments.addSql(new String[]{((NativeSql)value).getSql()}).addParameter(((NativeSql)value).getParameters());
        } else {
            fragments.addSql(new String[]{"?"}).addParameter(new Object[]{value});
        }
        fragments.addSql(new String[]{")"});
        return fragments;
    }

    @Override
    public String getType() {
        return this.name();
    }

    @Override
    public String getName() {
        return LocaleUtils.resolveMessage((String)("message.term_type_" + this.name()), (String)this.text, (Object[])new Object[0]);
    }

    public String getText() {
        return this.text;
    }

    public Set<String> getSupportTypes() {
        return this.supportTypes;
    }

    public String getFunction() {
        return this.function;
    }
}

