/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.config.web;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.annotation.QueryAction;
import org.hswebframework.web.authorization.annotation.Resource;
import org.hswebframework.web.authorization.annotation.SaveAction;
import org.hswebframework.web.bean.FastBeanCopier;
import org.jetlinks.community.ValueObject;
import org.jetlinks.community.config.ConfigManager;
import org.jetlinks.community.config.ConfigPropertyDef;
import org.jetlinks.community.config.ConfigScope;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/system/config"})
@Resource(id="system_config", name="\u7cfb\u7edf\u914d\u7f6e\u7ba1\u7406")
@Tag(name="\u7cfb\u7edf\u914d\u7f6e\u7ba1\u7406")
public class SystemConfigManagerController {
    private final ConfigManager configManager;

    @GetMapping(value={"/scopes"})
    @QueryAction
    @Operation(description="\u83b7\u53d6\u914d\u7f6e\u4f5c\u7528\u57df")
    public Flux<ConfigScope> getConfigScopes() {
        return this.configManager.getScopes();
    }

    @GetMapping(value={"/{scope}"})
    @Authorize(ignore=true)
    @Operation(description="\u83b7\u53d6\u4f5c\u7528\u57df\u4e0b\u7684\u5168\u90e8\u914d\u7f6e\u4fe1\u606f")
    public Mono<Map<String, Object>> getConfigs(@PathVariable String scope) {
        return Authentication.currentReactive().hasElement().flatMap(hasAuth -> this.configManager.getScope(scope).map(conf -> conf.isPublicAccess() || hasAuth != false).defaultIfEmpty(hasAuth).filter(Boolean::booleanValue).flatMap(ignore -> this.configManager.getProperties(scope)).map(ValueObject::values)).defaultIfEmpty(Collections.emptyMap());
    }

    @GetMapping(value={"/{scope}/_detail"})
    @QueryAction
    @Operation(description="\u83b7\u53d6\u4f5c\u7528\u57df\u4e0b\u7684\u914d\u7f6e\u4fe1\u606f")
    public Flux<ConfigPropertyValue> getConfigDetail(@PathVariable String scope) {
        return this.configManager.getProperties(scope).flatMapMany(values -> this.configManager.getPropertyDef(scope).map(def -> ConfigPropertyValue.of(def, values.get(def.getKey()).orElse(null))));
    }

    @PostMapping(value={"/scopes"})
    @QueryAction
    @Operation(description="\u83b7\u53d6\u4f5c\u7528\u57df\u4e0b\u7684\u914d\u7f6e\u8be6\u60c5")
    public Flux<Scope> getConfigDetail(@RequestBody Mono<List<String>> scopeMono) {
        return scopeMono.flatMapMany(scopes -> Flux.fromIterable((Iterable)scopes).flatMap(scope -> this.getConfigs((String)scope).map(properties -> new Scope((String)scope, (Map<String, Object>)properties))));
    }

    @PostMapping(value={"/{scope}"})
    @SaveAction
    @Operation(description="\u4fdd\u5b58\u914d\u7f6e")
    public Mono<Void> saveConfig(@PathVariable String scope, @RequestBody Mono<Map<String, Object>> properties) {
        return properties.flatMap(props -> this.configManager.setProperties(scope, (Map<String, Object>)props));
    }

    @PostMapping(value={"/scope/_save"})
    @SaveAction
    @Operation(description="\u6279\u91cf\u4fdd\u5b58\u914d\u7f6e")
    @Transactional
    public Mono<Void> saveConfig(@RequestBody Flux<Scope> scope) {
        return scope.flatMap(scopeConfig -> this.configManager.setProperties(scopeConfig.getScope(), scopeConfig.getProperties())).then();
    }

    public SystemConfigManagerController(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public static class Scope {
        private String scope;
        private Map<String, Object> properties;

        public String getScope() {
            return this.scope;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }

        public void setScope(String scope) {
            this.scope = scope;
        }

        public void setProperties(Map<String, Object> properties) {
            this.properties = properties;
        }

        public Scope(String scope, Map<String, Object> properties) {
            this.scope = scope;
            this.properties = properties;
        }

        public Scope() {
        }
    }

    public static class ConfigPropertyValue
    extends ConfigPropertyDef {
        private Object value;

        public static ConfigPropertyValue of(ConfigPropertyDef def, Object value) {
            ConfigPropertyValue val = (ConfigPropertyValue)FastBeanCopier.copy((Object)def, (Object)new ConfigPropertyValue(), (String[])new String[0]);
            val.setValue(value);
            return val;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }
    }
}

