/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.io.file.web;

import io.swagger.v3.oas.annotations.Operation;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.hswebframework.web.authorization.Authentication;
import org.hswebframework.web.authorization.annotation.Authorize;
import org.hswebframework.web.authorization.exception.AccessDenyException;
import org.jetlinks.community.io.file.FileInfo;
import org.jetlinks.community.io.file.FileManager;
import org.jetlinks.community.io.file.FileOption;
import org.springframework.http.ContentDisposition;
import org.springframework.http.HttpRange;
import org.springframework.http.MediaType;
import org.springframework.http.codec.multipart.FilePart;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@RestController
@RequestMapping(value={"/file"})
public class FileManagerController {
    private final FileManager fileManager;

    @PostMapping(value={"/upload"})
    @Authorize(merge=false)
    @Operation(summary="\u4e0a\u4f20\u6587\u4ef6")
    public Mono<FileInfo> upload(@RequestPart(value="file") Mono<FilePart> partMono) {
        return partMono.flatMap(x$0 -> this.fileManager.saveFile((FilePart)x$0, new FileOption[0]));
    }

    @GetMapping(value={"/{fileId}"})
    @Authorize(ignore=true)
    @Operation(summary="\u83b7\u53d6\u6587\u4ef6")
    public Mono<Void> read(@PathVariable String fileId, ServerWebExchange exchange) {
        return exchange.getResponse().writeWith(this.fileManager.read(fileId, (FileManager.ReaderContext ctx) -> {
            String key;
            Mono before = !ctx.info().hasOption(FileOption.publicAccess) ? (!StringUtils.hasText((String)(key = (String)exchange.getRequest().getQueryParams().getFirst((Object)"accessKey"))) ? Authentication.currentReactive().switchIfEmpty(Mono.error(AccessDenyException::new)).then() : (ctx.info().accessKey().map(key::equalsIgnoreCase).orElse(false).booleanValue() ? Mono.empty() : Mono.error(AccessDenyException::new))) : Mono.empty();
            return before.then(Mono.fromRunnable(() -> {
                List ranges = exchange.getRequest().getHeaders().getRange();
                long position = 0L;
                if (ranges.size() != 0) {
                    position = ((HttpRange)ranges.get(0)).getRangeStart(ctx.info().getLength());
                }
                ctx.position(position);
                MediaType mediaType = ctx.info().mediaType();
                exchange.getResponse().getHeaders().setContentType(mediaType);
                exchange.getResponse().getHeaders().setContentLength(ctx.info().getLength());
                exchange.getResponse().getHeaders().add("file-md5", ctx.info().getMd5());
                exchange.getResponse().getHeaders().add("file-sha256", ctx.info().getSha256());
                if (mediaType.includes(MediaType.APPLICATION_OCTET_STREAM)) {
                    exchange.getResponse().getHeaders().setContentDisposition(ContentDisposition.builder((String)"attachment").filename(ctx.info().getName(), StandardCharsets.UTF_8).build());
                }
            }));
        }));
    }

    public FileManagerController(FileManager fileManager) {
        this.fileManager = fileManager;
    }
}

