/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.http.device;

import io.netty.buffer.ByteBuf;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Optional;
import javax.annotation.Nullable;
import org.jetlinks.community.network.http.server.WebSocketExchange;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.message.codec.DefaultTransport;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.core.message.codec.http.websocket.DefaultWebSocketMessage;
import org.jetlinks.core.message.codec.http.websocket.WebSocketMessage;
import org.jetlinks.core.server.session.DeviceSession;
import org.jetlinks.core.utils.Reactors;
import reactor.core.publisher.Mono;

class HttpDeviceSession
implements DeviceSession {
    private final DeviceOperator operator;
    private final InetSocketAddress address;
    private WebSocketExchange websocket;
    private long lastPingTime = System.currentTimeMillis();
    private long keepAliveTimeOutMs = -1L;

    public HttpDeviceSession(DeviceOperator deviceOperator, InetSocketAddress address) {
        this.operator = deviceOperator;
        this.address = address;
    }

    public String getId() {
        return this.operator.getDeviceId();
    }

    public String getDeviceId() {
        return this.operator.getDeviceId();
    }

    @Nullable
    public DeviceOperator getOperator() {
        return this.operator;
    }

    public long lastPingTime() {
        return this.lastPingTime;
    }

    public long connectTime() {
        return this.lastPingTime;
    }

    public Mono<Boolean> send(EncodedMessage encodedMessage) {
        if (this.websocket == null) {
            return Reactors.ALWAYS_FALSE;
        }
        if (encodedMessage instanceof WebSocketMessage) {
            return this.websocket.send((WebSocketMessage)encodedMessage).thenReturn((Object)true);
        }
        return this.websocket.send((WebSocketMessage)DefaultWebSocketMessage.of((WebSocketMessage.Type)WebSocketMessage.Type.TEXT, (ByteBuf)encodedMessage.getPayload())).thenReturn((Object)true);
    }

    public Transport getTransport() {
        return DefaultTransport.HTTP;
    }

    public Optional<InetSocketAddress> getClientAddress() {
        return Optional.ofNullable(this.address);
    }

    public void close() {
    }

    public void setKeepAliveTimeout(Duration timeout) {
        this.keepAliveTimeOutMs = timeout.toMillis();
    }

    public void ping() {
        this.lastPingTime = System.currentTimeMillis();
    }

    public boolean isAlive() {
        return this.keepAliveTimeOutMs <= 0L || System.currentTimeMillis() - this.lastPingTime < this.keepAliveTimeOutMs;
    }

    public void onClose(Runnable call) {
    }

    public void setWebsocket(WebSocketExchange websocket) {
        this.websocket = websocket;
    }
}

