/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.http.server;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Collection;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.jetlinks.community.network.http.device.HttpServerExchangeMessage;
import org.jetlinks.community.network.http.server.HttpRequest;
import org.jetlinks.community.network.http.server.HttpResponse;
import org.jetlinks.core.message.codec.http.HttpExchangeMessage;
import org.jetlinks.core.message.codec.http.HttpResponseMessage;
import org.jetlinks.core.message.codec.http.MultiPart;
import org.jetlinks.core.message.codec.http.SimpleHttpResponseMessage;
import org.jetlinks.core.trace.TraceHolder;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import reactor.core.publisher.Mono;

public interface HttpExchange {
    public String requestId();

    public long timestamp();

    public HttpRequest request();

    public HttpResponse response();

    public boolean isClosed();

    default public Mono<Void> error(@NotNull HttpStatus status) {
        return this.response(status, "{\"message\":\"" + status.getReasonPhrase() + "\"}");
    }

    default public Mono<Void> ok() {
        return this.response(HttpStatus.OK, "{\"message\":\"OK\"}");
    }

    default public Mono<Void> response(@NotNull HttpStatus status, @NotNull String body) {
        return this.response((HttpResponseMessage)SimpleHttpResponseMessage.builder().contentType(MediaType.APPLICATION_JSON).status(status.value()).body(body.getBytes()).build());
    }

    default public Mono<Void> error(@NotNull HttpStatus status, @NotNull Throwable body) {
        return this.response(status, body.getMessage() == null ? body.getClass().getSimpleName() : body.getMessage());
    }

    default public Mono<Void> response(HttpResponseMessage message) {
        HttpResponse response = this.response();
        response.status(message.getStatus());
        if (CollectionUtils.isNotEmpty((Collection)message.getHeaders())) {
            message.getHeaders().forEach(response::header);
        }
        response.contentType(message.getContentType());
        return TraceHolder.writeContextTo((Object)response, HttpResponse::header).then(response.writeAndEnd(message.getPayload()));
    }

    default public Mono<HttpExchangeMessage> toExchangeMessage() {
        return Mono.zip((Mono)this.request().getBody().defaultIfEmpty((Object)Unpooled.EMPTY_BUFFER), this.request().multiPart(), (body, part) -> new HttpServerExchangeMessage(this, (ByteBuf)body, (MultiPart)part));
    }
}

