/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.http.device;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Optional;
import javax.annotation.Nullable;
import org.jetlinks.community.network.http.server.HttpExchange;
import org.jetlinks.core.device.DeviceOperator;
import org.jetlinks.core.message.codec.DefaultTransport;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.core.server.session.DeviceSession;
import reactor.core.publisher.Mono;

class UnknownHttpDeviceSession
implements DeviceSession {
    private final HttpExchange exchange;
    private Duration timeout;

    public UnknownHttpDeviceSession(HttpExchange exchange) {
        this.exchange = exchange;
    }

    public String getId() {
        return "unknown";
    }

    public String getDeviceId() {
        return "unknown";
    }

    @Nullable
    public DeviceOperator getOperator() {
        return null;
    }

    public long lastPingTime() {
        return 0L;
    }

    public long connectTime() {
        return 0L;
    }

    public Mono<Boolean> send(EncodedMessage encodedMessage) {
        return Mono.empty();
    }

    public Transport getTransport() {
        return DefaultTransport.HTTP;
    }

    public void close() {
    }

    public void ping() {
    }

    public boolean isAlive() {
        return true;
    }

    public void onClose(Runnable call) {
    }

    public void setKeepAliveTimeout(Duration timeout) {
        this.timeout = timeout;
    }

    public Duration getKeepAliveTimeout() {
        return this.timeout;
    }

    public Optional<InetSocketAddress> getClientAddress() {
        return Optional.of(this.exchange.request().getClientAddress());
    }
}

