/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.community.network.http.device;

import java.util.Objects;
import org.jetlinks.community.gateway.DeviceGateway;
import org.jetlinks.community.gateway.supports.DeviceGatewayProperties;
import org.jetlinks.community.gateway.supports.DeviceGatewayProvider;
import org.jetlinks.community.network.DefaultNetworkType;
import org.jetlinks.community.network.NetworkManager;
import org.jetlinks.community.network.NetworkType;
import org.jetlinks.community.network.http.device.HttpServerDeviceGateway;
import org.jetlinks.community.network.http.server.HttpServer;
import org.jetlinks.core.ProtocolSupport;
import org.jetlinks.core.ProtocolSupports;
import org.jetlinks.core.device.DeviceRegistry;
import org.jetlinks.core.device.session.DeviceSessionManager;
import org.jetlinks.core.message.codec.DefaultTransport;
import org.jetlinks.core.message.codec.Transport;
import org.jetlinks.supports.server.DecodedClientMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import reactor.core.publisher.Mono;

@Component
public class HttpServerDeviceGatewayProvider
implements DeviceGatewayProvider {
    private static final Logger log = LoggerFactory.getLogger(HttpServerDeviceGatewayProvider.class);
    private final NetworkManager networkManager;
    private final DeviceRegistry registry;
    private final DeviceSessionManager sessionManager;
    private final DecodedClientMessageHandler clientMessageHandler;
    private final ProtocolSupports protocolSupports;

    public HttpServerDeviceGatewayProvider(NetworkManager networkManager, DeviceRegistry registry, DeviceSessionManager sessionManager, DecodedClientMessageHandler clientMessageHandler, ProtocolSupports protocolSupports) {
        this.networkManager = networkManager;
        this.registry = registry;
        this.sessionManager = sessionManager;
        this.clientMessageHandler = clientMessageHandler;
        this.protocolSupports = protocolSupports;
    }

    public String getId() {
        return "http-server-gateway";
    }

    public String getName() {
        return "HTTP \u63a8\u9001\u63a5\u5165";
    }

    public Transport getTransport() {
        return DefaultTransport.HTTP;
    }

    public Mono<DeviceGateway> createDeviceGateway(DeviceGatewayProperties properties) {
        return this.networkManager.getNetwork((NetworkType)DefaultNetworkType.HTTP_SERVER, properties.getChannelId()).map(server -> {
            String protocol = properties.getProtocol();
            return new HttpServerDeviceGateway(properties.getId(), (HttpServer)server, (Mono<ProtocolSupport>)Mono.defer(() -> this.protocolSupports.getProtocol(protocol)), this.sessionManager, this.registry, this.clientMessageHandler);
        });
    }

    public Mono<? extends DeviceGateway> reloadDeviceGateway(DeviceGateway gateway, DeviceGatewayProperties properties) {
        HttpServerDeviceGateway deviceGateway = (HttpServerDeviceGateway)gateway;
        String networkId = properties.getChannelId();
        if (!Objects.equals(networkId, deviceGateway.httpServer.getId())) {
            return gateway.shutdown().then(this.createDeviceGateway(properties).flatMap(gate -> gate.startup().thenReturn(gate)));
        }
        deviceGateway.setProtocol((Mono<ProtocolSupport>)this.protocolSupports.getProtocol(properties.getProtocol()));
        return deviceGateway.reload().thenReturn((Object)deviceGateway);
    }

    public static class RouteConfig {
        private String url;
        private String protocol;

        public String getUrl() {
            return this.url;
        }

        public String getProtocol() {
            return this.protocol;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setProtocol(String protocol) {
            this.protocol = protocol;
        }
    }
}

